/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.customizer;

import org.seasar.framework.aop.interceptors.SimpleTraceInterceptor;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.Greeting;
import org.seasar.framework.container.autoregister.GreetingInterceptor;
import org.seasar.framework.container.customizer.AspectCustomizer;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class AspectCustomizerTest
extends S2FrameworkTestCase {
    private S2Container child;

    public void setUpCustomize() throws Exception {
        this.include("AspectCustomizerTest.dicon");
    }

    public void testCustomize() throws Exception {
        ComponentDef cd = this.child.getComponentDef((Object)Greeting.class);
        AspectCustomizerTest.assertEquals((int)3, (int)cd.getAspectDefSize());
        AspectDef ad = cd.getAspectDef(0);
        AspectCustomizerTest.assertEquals((Object)TraceInterceptor.class, ad.getAspect().getMethodInterceptor().getClass());
        ad = cd.getAspectDef(1);
        AspectCustomizerTest.assertEquals((Object)GreetingInterceptor.class, ad.getAspect().getMethodInterceptor().getClass());
        ad = cd.getAspectDef(2);
        AspectCustomizerTest.assertEquals((Object)SimpleTraceInterceptor.class, ad.getAspect().getMethodInterceptor().getClass());
        Greeting greeting = (Greeting)cd.getComponent();
        AspectCustomizerTest.assertNotNull((String)"1", (Object)greeting);
        AspectCustomizerTest.assertEquals((String)"2", (String)"Hello", (String)greeting.greet());
    }

    public void setUpDelegate() throws Exception {
        this.include("AspectCustomizerTest2.dicon");
    }

    public void testDelegate() throws Exception {
        ComponentDef cd = this.child.getComponentDef((Object)Greeting.class);
        AspectCustomizerTest.assertEquals((int)2, (int)cd.getAspectDefSize());
        AspectDef ad = cd.getAspectDef(0);
        AspectCustomizerTest.assertEquals((Object)AspectCustomizer.LookupAdaptorInterceptor.class, ad.getAspect().getMethodInterceptor().getClass());
        Greeting greeting = (Greeting)cd.getComponent();
        AspectCustomizerTest.assertNotNull((String)"1", (Object)greeting);
        String result1 = greeting.greet();
        AspectCustomizerTest.assertNotNull((Object)result1);
        String result2 = greeting.greet();
        AspectCustomizerTest.assertNotNull((Object)result2);
        AspectCustomizerTest.assertNotSame((Object)result1, (Object)result2);
    }
}

