/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.creator;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.creator.ComponentCreatorImpl;
import org.seasar.framework.container.creator.dao.AaaDao;
import org.seasar.framework.container.creator.dao.BbbDao;
import org.seasar.framework.container.creator.dao.impl.BbbDaoImpl;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.util.ClassUtil;

public class ComponentCreatorImplTest
extends TestCase {
    private String rootPackageName = ClassUtil.getPackageName(((Object)((Object)this)).getClass());
    private ComponentCreatorImpl creator;

    protected void setUp() {
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName(this.rootPackageName);
        this.creator = new ComponentCreatorImpl((NamingConvention)convention);
        this.creator.setNameSuffix("Dao");
        this.creator.setEnableInterface(true);
        this.creator.setEnableAbstract(true);
    }

    public void testCreateComponentDef() throws Exception {
        ComponentDef cd = this.creator.createComponentDef(AaaDao.class);
        ComponentCreatorImplTest.assertNotNull((Object)cd);
        ComponentCreatorImplTest.assertEquals((Object)AaaDao.class, (Object)cd.getComponentClass());
        ComponentCreatorImplTest.assertEquals((String)"aaaDao", (String)cd.getComponentName());
        cd = this.creator.createComponentDef(BbbDao.class);
        ComponentCreatorImplTest.assertNotNull((Object)cd);
        ComponentCreatorImplTest.assertEquals((Object)BbbDaoImpl.class, (Object)cd.getComponentClass());
        ComponentCreatorImplTest.assertEquals((String)"bbbDao", (String)cd.getComponentName());
    }
}

