/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import junit.framework.TestCase;
import org.seasar.framework.container.autoregister.ClassPattern;

public class ClassPatternTest
extends TestCase {
    public void testAppliedForShortClassNameNull() throws Exception {
        ClassPattern cp = new ClassPattern();
        ClassPatternTest.assertTrue((String)"1", (boolean)cp.isAppliedShortClassName("Hoge"));
    }

    public void testAppliedForNormalPattern() throws Exception {
        ClassPattern cp = new ClassPattern();
        cp.setShortClassNames(".*Impl");
        ClassPatternTest.assertTrue((String)"1", (boolean)cp.isAppliedShortClassName("HogeImpl"));
        ClassPatternTest.assertFalse((String)"2", (boolean)cp.isAppliedShortClassName("Hoge"));
    }

    public void testAppliedForMulti() throws Exception {
        ClassPattern cp = new ClassPattern();
        cp.setShortClassNames("Hoge, HogeImpl");
        ClassPatternTest.assertTrue((String)"1", (boolean)cp.isAppliedShortClassName("HogeImpl"));
        ClassPatternTest.assertTrue((String)"2", (boolean)cp.isAppliedShortClassName("Hoge"));
        ClassPatternTest.assertFalse((String)"3", (boolean)cp.isAppliedShortClassName("Hoge2"));
    }

    public void testAppliedPackageName() throws Exception {
        ClassPattern cp = new ClassPattern();
        cp.setPackageName("org.seasar");
        ClassPatternTest.assertTrue((boolean)cp.isAppliedPackageName("org.seasar"));
        ClassPatternTest.assertTrue((boolean)cp.isAppliedPackageName("org.seasar.framework"));
        ClassPatternTest.assertFalse((boolean)cp.isAppliedPackageName("org"));
        ClassPatternTest.assertFalse((boolean)cp.isAppliedPackageName("org.seasar2"));
        ClassPatternTest.assertFalse((boolean)cp.isAppliedPackageName(null));
        cp.setPackageName(null);
        ClassPatternTest.assertTrue((boolean)cp.isAppliedPackageName(null));
        ClassPatternTest.assertFalse((boolean)cp.isAppliedPackageName("org"));
    }
}

