/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.framework.beans.util.BeanUtil;

public class BeanUtilTest
extends TestCase {
    public void testCopyProperties() throws Exception {
        MyClass src = new MyClass();
        src.setAaa("111");
        src.setCcc("333");
        MyClass2 dest = new MyClass2();
        dest.setAaa("aaa");
        dest.setBbb("bbb");
        dest.setDdd("ddd");
        BeanUtil.copyProperties((Object)src, (Object)dest);
        BeanUtilTest.assertEquals((String)"111", (String)dest.getAaa());
        BeanUtilTest.assertNull((Object)dest.getBbb());
        BeanUtilTest.assertEquals((String)"ddd", (String)dest.getDdd());
    }

    public void testCopyPropertiesWithoutNull() throws Exception {
        MyClass src = new MyClass();
        src.setAaa("111");
        src.setCcc("333");
        MyClass2 dest = new MyClass2();
        dest.setAaa("aaa");
        dest.setBbb("bbb");
        dest.setDdd("ddd");
        BeanUtil.copyProperties((Object)src, (Object)dest, (boolean)false);
        BeanUtilTest.assertEquals((String)"111", (String)dest.getAaa());
        BeanUtilTest.assertEquals((String)"bbb", (String)dest.getBbb());
        BeanUtilTest.assertEquals((String)"ddd", (String)dest.getDdd());
    }

    public void testCopyToMap() throws Exception {
        HogeDto hoge = new HogeDto();
        hoge.setA("A");
        hoge.setB(true);
        hoge.setC(3);
        HashMap map = new HashMap();
        BeanUtil.copyProperties((Object)hoge, map);
        BeanUtilTest.assertNotNull(map);
        BeanUtilTest.assertEquals((Object)"A", map.get("a"));
        BeanUtilTest.assertEquals((Object)new Boolean(true), map.get("b"));
        BeanUtilTest.assertEquals((Object)new Integer(3), map.get("c"));
    }

    public void testCopyToBean() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", "A");
        map.put("b", new Boolean(true));
        map.put("c", new Integer(3));
        map.put("d", new Double(1.4));
        HogeDto hoge = new HogeDto();
        BeanUtil.copyProperties(map, (Object)hoge);
        BeanUtilTest.assertEquals((String)"A", (String)hoge.getA());
        BeanUtilTest.assertEquals((Object)new Boolean(true), (Object)new Boolean(hoge.isB()));
        BeanUtilTest.assertEquals((Object)new Integer(3), (Object)new Integer(hoge.getC()));
    }

    public void testCreateProperties() throws Exception {
        HogeDto2 hoge = new HogeDto2();
        hoge.aaa = "1";
        hoge.search_bbb = "2";
        hoge.search_ccc$ddd = "3";
        hoge.search_employee$name = "4";
        Map map = BeanUtil.createProperties((Object)hoge, (String)"search_");
        BeanUtilTest.assertEquals((int)3, (int)map.size());
        BeanUtilTest.assertEquals((Object)"2", map.get("bbb"));
        BeanUtilTest.assertEquals((Object)"3", map.get("ccc.ddd"));
        BeanUtilTest.assertEquals((Object)"4", map.get("employee.name"));
    }

    public void testCreateProperties_nonPrefix() throws Exception {
        HogeDto2 hoge = new HogeDto2();
        hoge.aaa = "1";
        hoge.search_bbb = "2";
        hoge.search_ccc$ddd = "3";
        Map map = BeanUtil.createProperties((Object)hoge);
        BeanUtilTest.assertEquals((int)4, (int)map.size());
        BeanUtilTest.assertEquals((Object)"1", map.get("aaa"));
        BeanUtilTest.assertEquals((Object)"2", map.get("search_bbb"));
        BeanUtilTest.assertEquals((Object)"3", map.get("search_ccc.ddd"));
        BeanUtilTest.assertNull(map.get("employee.name"));
    }

    public static class MyClass2 {
        private String aaa;
        private String bbb;
        private String ddd;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }

        public String getBbb() {
            return this.bbb;
        }

        public void setBbb(String bbb) {
            this.bbb = bbb;
        }

        public String getDdd() {
            return this.ddd;
        }

        public void setDdd(String ddd) {
            this.ddd = ddd;
        }
    }

    public static class MyClass {
        private String aaa;
        private String bbb;
        private String ccc;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }

        public String getBbb() {
            return this.bbb;
        }

        public void setBbb(String bbb) {
            this.bbb = bbb;
        }

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }
    }

    public static class HogeDto2 {
        public String aaa;
        public String search_bbb;
        public String search_ccc$ddd;
        public String search_employee$name;
    }

    public static class HogeDto {
        private String a;
        private boolean b;
        private int c;

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public boolean isB() {
            return this.b;
        }

        public void setB(boolean b) {
            this.b = b;
        }

        public int getC() {
            return this.c;
        }

        public void setC(int c) {
            this.c = c;
        }
    }
}

