/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.impl.BeanDescImpl;
import org.seasar.framework.beans.impl.sub.MogeBean;
import org.seasar.framework.beans.impl.sub.MogeBeanFactory;

public class PropertyDescImplTest
extends TestCase {
    public void testSetValue() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("fff");
        propDesc.setValue((Object)myBean, (Object)new BigDecimal(2.0));
        PropertyDescImplTest.assertEquals((int)2, (int)myBean.getFff());
    }

    public void testSetValue_null() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("fff");
        propDesc.setValue((Object)myBean, null);
        PropertyDescImplTest.assertEquals((int)0, (int)myBean.getFff());
    }

    public void testSetValue_notWritable() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("aaa");
        try {
            propDesc.setValue((Object)myBean, null);
            PropertyDescImplTest.fail();
        }
        catch (IllegalPropertyRuntimeException e) {
            System.out.println((Object)e);
        }
    }

    public void testSetValue_notWritableWithField() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("jjj");
        try {
            propDesc.setValue((Object)myBean, null);
            PropertyDescImplTest.fail();
        }
        catch (IllegalPropertyRuntimeException e) {
            System.out.println((Object)e);
        }
    }

    public void testSetValue_invalidType() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("url");
        try {
            propDesc.setValue((Object)myBean, new Object());
            PropertyDescImplTest.fail();
        }
        catch (IllegalPropertyRuntimeException expected) {
            expected.printStackTrace();
        }
    }

    public void testGetValue_notReable() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("iii");
        try {
            propDesc.getValue((Object)myBean);
            PropertyDescImplTest.fail();
        }
        catch (IllegalPropertyRuntimeException e) {
            System.out.println((Object)e);
        }
    }

    public void testGetValue_notReableWithField() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("kkk");
        try {
            propDesc.getValue((Object)myBean);
            PropertyDescImplTest.fail();
        }
        catch (IllegalPropertyRuntimeException e) {
            System.out.println((Object)e);
        }
    }

    public void testSetIllegalValue() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("fff");
        try {
            propDesc.setValue((Object)myBean, (Object)"hoge");
            PropertyDescImplTest.fail((String)"1");
        }
        catch (IllegalPropertyRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testSetBigDecimalValue() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("ggg");
        propDesc.setValue((Object)myBean, (Object)new Integer(1));
        PropertyDescImplTest.assertEquals((String)"1", (Object)new BigDecimal(1.0), (Object)myBean.getGgg());
    }

    public void testSetTimestampValue() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("hhh");
        propDesc.setValue((Object)myBean, (Object)"2000/11/8");
        PropertyDescImplTest.assertNotNull((String)"1", (Object)myBean.getHhh());
    }

    public void testSetCalendarValue() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("cal");
        Date date = new Date();
        propDesc.setValue((Object)myBean, (Object)date);
        PropertyDescImplTest.assertEquals((Object)date, (Object)myBean.getCal().getTime());
    }

    public void testSetIntegerValueToString() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("str");
        propDesc.setValue((Object)myBean, (Object)new Integer(1));
        PropertyDescImplTest.assertEquals((String)"1", (String)myBean.str);
    }

    public void testSetNullToString() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("str");
        propDesc.setValue((Object)myBean, null);
        PropertyDescImplTest.assertNull((Object)myBean.str);
    }

    public void testConvertWithStringConstructor() throws Exception {
        MyBean myBean = new MyBean();
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("URL");
        propDesc.setValue((Object)myBean, (Object)"http://www.seasar.org");
        PropertyDescImplTest.assertNotNull((String)"1", (Object)myBean.getURL());
    }

    public void testGetBeanDesc() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("URL");
        PropertyDescImplTest.assertNotNull((Object)propDesc.getBeanDesc());
    }

    public void testPackagePrivateBean() throws Exception {
        MogeBean moge = MogeBeanFactory.create("moge");
        BeanDescImpl beanDesc = new BeanDescImpl(moge.getClass());
        PropertyDesc propDesc = beanDesc.getPropertyDesc("name");
        PropertyDescImplTest.assertNotNull((Object)propDesc);
        PropertyDescImplTest.assertEquals((Object)"moge", (Object)propDesc.getValue((Object)moge));
    }

    public static class MyBean {
        private int fff_;
        private BigDecimal ggg_;
        private Timestamp hhh_;
        private String jjj;
        String kkk;
        private URL url_;
        private Calendar cal;
        public String str;

        public String getAaa() {
            return null;
        }

        public String getBbb(Object a) {
            return null;
        }

        public boolean isCCC() {
            return true;
        }

        public Object isDdd() {
            return null;
        }

        public String getEee() {
            return null;
        }

        public void setEee(String eee) {
        }

        public int getFff() {
            return this.fff_;
        }

        public void setFff(int fff) {
            this.fff_ = fff;
        }

        public String getJjj() {
            return this.jjj;
        }

        public void setKkk(String kkk) {
            this.kkk = kkk;
        }

        public Number add(Number arg1, Number arg2) {
            return new Integer(3);
        }

        public BigDecimal getGgg() {
            return this.ggg_;
        }

        public void setGgg(BigDecimal ggg) {
            this.ggg_ = ggg;
        }

        public Timestamp getHhh() {
            return this.hhh_;
        }

        public void setHhh(Timestamp hhh) {
            this.hhh_ = hhh;
        }

        public void setIii(String iii) {
        }

        public URL getURL() {
            return this.url_;
        }

        public void setURL(URL url) {
            this.url_ = url;
        }

        public Calendar getCal() {
            return this.cal;
        }

        public void setCal(Calendar cal) {
            this.cal = cal;
        }
    }
}

