/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.javassist.EnhancedClassGenerator;
import org.seasar.framework.util.ClassPoolUtil;

public class EnhancedClassGeneratorTest
extends TestCase {
    static /* synthetic */ Class class$org$seasar$framework$aop$javassist$MethodInvocationClassGenerator$MethodInvocationTemplate;

    public void testNormalizeExceptionTypes() throws Exception {
        EnhancedClassGeneratorTest.assertTrue((String)"1", (boolean)Arrays.equals(new Class[]{Throwable.class}, EnhancedClassGenerator.normalizeExceptionTypes((Class[])new Class[]{Throwable.class})));
        EnhancedClassGeneratorTest.assertTrue((String)"2", (boolean)Arrays.equals(new Class[]{Throwable.class}, EnhancedClassGenerator.normalizeExceptionTypes((Class[])new Class[]{Throwable.class, Exception.class})));
        EnhancedClassGeneratorTest.assertTrue((String)"3", (boolean)Arrays.equals(new Class[]{Throwable.class}, EnhancedClassGenerator.normalizeExceptionTypes((Class[])new Class[]{Throwable.class, Exception.class, Error.class})));
        EnhancedClassGeneratorTest.assertTrue((String)"4", (boolean)Arrays.equals(new Class[]{Exception.class, Error.class}, EnhancedClassGenerator.normalizeExceptionTypes((Class[])new Class[]{Exception.class, Error.class})));
        EnhancedClassGeneratorTest.assertTrue((String)"5", (boolean)Arrays.equals(new Class[]{Exception.class, Error.class}, EnhancedClassGenerator.normalizeExceptionTypes((Class[])new Class[]{RuntimeException.class, Exception.class, Error.class})));
        EnhancedClassGeneratorTest.assertTrue((String)"6", (boolean)Arrays.equals(new Class[]{RuntimeException.class, IOException.class, Error.class}, EnhancedClassGenerator.normalizeExceptionTypes((Class[])new Class[]{RuntimeException.class, IOException.class, Error.class})));
    }

    public void testAroundTryCatchBlock() throws Exception {
        EnhancedClassGeneratorTest.assertEquals((String)"1", (String)"try {return;}catch (java.lang.Exception e) {throw e;}catch (java.lang.RuntimeException e) {throw e;}catch (java.lang.Error e) {throw e;}catch (java.lang.Throwable e) {throw new java.lang.reflect.UndeclaredThrowableException(e);}", (String)EnhancedClassGenerator.aroundTryCatchBlock((Class[])new Class[]{Exception.class}, (String)"return;"));
        EnhancedClassGeneratorTest.assertEquals((String)"2", (String)"try {return;}catch (java.lang.RuntimeException e) {throw e;}catch (java.io.IOException e) {throw e;}catch (java.lang.Error e) {throw e;}catch (java.lang.Throwable e) {throw new java.lang.reflect.UndeclaredThrowableException(e);}", (String)EnhancedClassGenerator.aroundTryCatchBlock((Class[])new Class[]{RuntimeException.class, IOException.class}, (String)"return;"));
    }

    public void testCreateTargetMethodSource() throws Exception {
        Method method1 = Object.class.getMethod("hashCode", null);
        EnhancedClassGeneratorTest.assertEquals((String)"1", (String)"{try {Object result = new MethodInvocation(this, $args).proceed();return ($r) ((result == null) ? 0 : ((java.lang.Number) result).intValue());}catch (java.lang.RuntimeException e) {throw e;}catch (java.lang.Error e) {throw e;}catch (java.lang.Throwable e) {throw new java.lang.reflect.UndeclaredThrowableException(e);}}", (String)EnhancedClassGenerator.createTargetMethodSource((Method)method1, (String)"MethodInvocation"));
        Method method2 = Object.class.getMethod("wait", null);
        EnhancedClassGeneratorTest.assertEquals((String)"2", (String)"{try {Object result = new MethodInvocation(this, $args).proceed();return;}catch (java.lang.InterruptedException e) {throw e;}catch (java.lang.RuntimeException e) {throw e;}catch (java.lang.Error e) {throw e;}catch (java.lang.Throwable e) {throw new java.lang.reflect.UndeclaredThrowableException(e);}}", (String)EnhancedClassGenerator.createTargetMethodSource((Method)method2, (String)"MethodInvocation"));
        Method method3 = MethodInvocation.class.getMethod("proceed", null);
        EnhancedClassGeneratorTest.assertEquals((String)"3", (String)"{Object result = new MethodInvocation(this, $args).proceed();return ($r) result;}", (String)EnhancedClassGenerator.createTargetMethodSource((Method)method3, (String)"MethodInvocation"));
    }

    public void testCreateInvokeSuperMethodSource() throws Exception {
        Method method = Object.class.getMethod("wait", null);
        EnhancedClassGeneratorTest.assertEquals((String)"1", (String)"{return ($r) super.wait($$);}", (String)EnhancedClassGenerator.createInvokeSuperMethodSource((Method)method));
    }

    public void testGenerateFromInterface() throws Exception {
        Method[] methods = TargetInterface.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            EnhancedClassGenerator generator = new EnhancedClassGenerator(ClassPoolUtil.getClassPool((Class)(class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface)), class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface, (class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface).getName() + i);
            generator.createTargetMethod(methods[i], (class$org$seasar$framework$aop$javassist$MethodInvocationClassGenerator$MethodInvocationTemplate == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGenerator$MethodInvocationTemplate") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGenerator$MethodInvocationTemplate).getName());
            Class clazz = generator.toClass(((Object)((Object)this)).getClass().getClassLoader());
            EnhancedClassGeneratorTest.assertEquals((String)"1", (String)((class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetInterface).getName() + i), (String)clazz.getName());
            Method method = clazz.getDeclaredMethod(methods[i].getName(), methods[i].getParameterTypes());
            EnhancedClassGeneratorTest.assertEquals((String)"2", (String)methods[i].getName(), (String)method.getName());
        }
    }

    public void testGenerateFromClass() throws Exception {
        Method[] methods = TargetClass.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            EnhancedClassGenerator generator = new EnhancedClassGenerator(ClassPoolUtil.getClassPool((Class)(class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass)), class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass, (class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass).getName() + i);
            generator.createInvokeSuperMethod(methods[i], methods[i].getName() + "__invokeSuper__");
            generator.createTargetMethod(methods[i], (class$org$seasar$framework$aop$javassist$MethodInvocationClassGenerator$MethodInvocationTemplate == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGenerator$MethodInvocationTemplate") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGenerator$MethodInvocationTemplate).getName());
            Class clazz = generator.toClass(((Object)((Object)this)).getClass().getClassLoader());
            EnhancedClassGeneratorTest.assertEquals((String)"1", (String)((class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass == null ? EnhancedClassGeneratorTest.class$("org.seasar.framework.aop.javassist.EnhancedClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$EnhancedClassGeneratorTest$TargetClass).getName() + i), (String)clazz.getName());
            Method method = clazz.getDeclaredMethod(methods[i].getName(), methods[i].getParameterTypes());
            EnhancedClassGeneratorTest.assertEquals((String)"2", (String)methods[i].getName(), (String)method.getName());
            Method invokeSuperMethod = clazz.getDeclaredMethod(methods[i].getName() + "__invokeSuper__", methods[i].getParameterTypes());
            EnhancedClassGeneratorTest.assertEquals((String)"3", (String)(methods[i].getName() + "__invokeSuper__"), (String)invokeSuperMethod.getName());
        }
    }

    public static class TargetClass {
        public void fVoid() {
        }

        public boolean fBoolean() {
            return false;
        }

        public char fChar() {
            return '\u0000';
        }

        public byte fByte() {
            return 0;
        }

        public short fShort() {
            return 0;
        }

        public int fInt() {
            return 0;
        }

        public long fLong() {
            return 0L;
        }

        public float fFloat() {
            return 0.0f;
        }

        public double fDouble() {
            return 0.0;
        }

        public int[] fIntArray() {
            return new int[0];
        }

        public int[][] fInt2DArray() {
            return new int[0][0];
        }

        public Object fObject() {
            return null;
        }

        public Object[] fObjectArray() {
            return new Object[0];
        }

        public String fString() {
            return "";
        }

        public String[] fStringArray() {
            return new String[0];
        }

        public boolean f(boolean arg0) {
            return arg0;
        }

        public char f(char arg0) {
            return arg0;
        }

        public byte f(byte arg0) {
            return arg0;
        }

        public short f(short arg0) {
            return arg0;
        }

        public int f(int arg0) {
            return arg0;
        }

        public long f(long arg0) {
            return arg0;
        }

        public float f(float arg0) {
            return arg0;
        }

        public double f(double arg0) {
            return arg0;
        }

        public int[] f(int[] arg0) {
            return arg0;
        }

        public int[][] f(int[][] arg0) {
            return arg0;
        }

        public Object f(Object arg0) {
            return arg0;
        }

        public Object[] f(Object[] arg0) {
            return arg0;
        }

        public String f(String arg0) {
            return arg0;
        }

        public String[] f(String[] arg0) {
            return arg0;
        }

        public void f(boolean arg0, char arg1, byte arg2, short arg3, int arg4, long arg5, float arg6, double arg7, int[] arg8, int[][] arg9, Object arg10, Object[] arg11, String arg12, String[] arg13) {
        }
    }

    public static interface TargetInterface {
        public void fVoid();

        public boolean fBoolean();

        public char fChar();

        public byte fByte();

        public short fShort();

        public int fInt();

        public long fLong();

        public float fFloat();

        public double fDouble();

        public int[] fIntArray();

        public int[][] fInt2DArray();

        public Object fObject();

        public Object[] fObjectArray();

        public String fString();

        public String[] fStringArray();

        public boolean f(boolean var1);

        public char f(char var1);

        public byte f(byte var1);

        public short f(short var1);

        public int f(int var1);

        public long f(long var1);

        public float f(float var1);

        public double f(double var1);

        public int[] f(int[] var1);

        public int[][] f(int[][] var1);

        public Object f(Object var1);

        public Object[] f(Object[] var1);

        public String f(String var1);

        public String[] f(String[] var1);

        public void f(boolean var1, char var2, byte var3, short var4, int var5, long var6, float var8, double var9, int[] var11, int[][] var12, Object var13, Object[] var14, String var15, String[] var16);
    }
}

