/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.impl;

import java.util.Date;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.proxy.AopProxy;

public class MethodInvocationImplTest
extends TestCase {
    public void testProceed() throws Exception {
        TestInterceptor interceptor = new TestInterceptor();
        TestInterceptor interceptor2 = new TestInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"getTime"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AspectImpl aspect2 = new AspectImpl((MethodInterceptor)interceptor2, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Date.class, new Aspect[]{aspect, aspect2});
        Date proxy = (Date)aopProxy.create();
        System.out.println(proxy.getTime());
        MethodInvocationImplTest.assertEquals((String)"1", (boolean)true, (boolean)interceptor.invoked_);
        MethodInvocationImplTest.assertEquals((String)"2", (boolean)true, (boolean)interceptor2.invoked_);
    }

    public void testProceedForAbstractMethod() throws Exception {
        HogeInterceptor interceptor = new HogeInterceptor();
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor);
        AopProxy aopProxy = new AopProxy(Hoge.class, new Aspect[]{aspect});
        Hoge proxy = (Hoge)aopProxy.create();
        MethodInvocationImplTest.assertEquals((String)"1", (String)"Hello", (String)proxy.foo());
    }

    public static class HogeInterceptor
    implements MethodInterceptor {
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return "Hello";
        }
    }

    public static interface Hoge {
        public String foo();
    }

    public class TestInterceptor
    implements MethodInterceptor {
        private boolean invoked_ = false;

        public Object invoke(MethodInvocation invocation) throws Throwable {
            this.invoked_ = true;
            return invocation.proceed();
        }
    }
}

