/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.io.InputStream;
import java.io.Reader;
import junit.framework.TestCase;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.ReaderUtil;

public class MockHttpServletRequestImplTest
extends TestCase {
    private MockServletContextImpl context_;
    private MockHttpServletRequestImpl request_;

    public void testAddParameter() throws Exception {
        this.request_.addParameter("aaa", "111");
        String[] values = this.request_.getParameterValues("aaa");
        MockHttpServletRequestImplTest.assertEquals((String)"1", (int)1, (int)values.length);
        MockHttpServletRequestImplTest.assertEquals((String)"2", (String)"111", (String)values[0]);
        this.request_.addParameter("aaa", "222");
        values = this.request_.getParameterValues("aaa");
        MockHttpServletRequestImplTest.assertEquals((String)"3", (int)2, (int)values.length);
        MockHttpServletRequestImplTest.assertEquals((String)"4", (String)"111", (String)values[0]);
        MockHttpServletRequestImplTest.assertEquals((String)"5", (String)"222", (String)values[1]);
        this.request_.addParameter("aaa", new String[]{"333", "444"});
        values = this.request_.getParameterValues("aaa");
        MockHttpServletRequestImplTest.assertEquals((String)"6", (int)4, (int)values.length);
        MockHttpServletRequestImplTest.assertEquals((String)"7", (String)"111", (String)values[0]);
        MockHttpServletRequestImplTest.assertEquals((String)"8", (String)"222", (String)values[1]);
        MockHttpServletRequestImplTest.assertEquals((String)"9", (String)"333", (String)values[2]);
        MockHttpServletRequestImplTest.assertEquals((String)"10", (String)"444", (String)values[3]);
    }

    public void testSetContent() throws Exception {
        String content = "aaa";
        this.request_.setContent(content.getBytes());
        MockHttpServletRequestImplTest.assertEquals((String)"1", (int)content.length(), (int)this.request_.getContentLength());
        MockHttpServletRequestImplTest.assertEquals((String)"2", (String)content, (String)new String(InputStreamUtil.getBytes((InputStream)this.request_.getInputStream())));
        MockHttpServletRequestImplTest.assertEquals((String)"3", (String)content, (String)ReaderUtil.readText((Reader)this.request_.getReader()));
    }

    protected void setUp() throws Exception {
        this.context_ = new MockServletContextImpl("/s2jsf-example");
        this.request_ = (MockHttpServletRequestImpl)this.context_.createRequest("/hello.html");
    }
}

