/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.lang.reflect.Field;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.util.ConstantAnnotationUtil;

public class ConstantAnnotationUtilTest
extends TestCase {
    public void testConvertExpressionToMap() throws Exception {
        Map map = ConstantAnnotationUtil.convertExpressionToMap((String)"required");
        ConstantAnnotationUtilTest.assertEquals((Object)"required", map.get(null));
        map = ConstantAnnotationUtil.convertExpressionToMap((String)"hoge=aaa");
        ConstantAnnotationUtilTest.assertEquals((Object)"aaa", map.get("hoge"));
        map = ConstantAnnotationUtil.convertExpressionToMap((String)"hoge=aaa, hoge2=bbb");
        ConstantAnnotationUtilTest.assertEquals((Object)"aaa", map.get("hoge"));
        ConstantAnnotationUtilTest.assertEquals((Object)"bbb", map.get("hoge2"));
        map = ConstantAnnotationUtil.convertExpressionToMap((String)"hoge='aaa,=', hoge2=bbb");
        ConstantAnnotationUtilTest.assertEquals((Object)"aaa,=", map.get("hoge"));
        ConstantAnnotationUtilTest.assertEquals((Object)"bbb", map.get("hoge2"));
        map = ConstantAnnotationUtil.convertExpressionToMap((String)"hoge=9999.99");
        ConstantAnnotationUtilTest.assertEquals((Object)"9999.99", map.get("hoge"));
        map = ConstantAnnotationUtil.convertExpressionToMap((String)"hoge=-9999.99");
        ConstantAnnotationUtilTest.assertEquals((Object)"-9999.99", map.get("hoge"));
    }

    public void testEOF() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer("");
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
    }

    public void testWhitespace() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer("\t       \n");
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
    }

    public void fixme_testHyphen() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer("       - ");
        ConstantAnnotationUtilTest.assertEquals((int)45, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
    }

    public void pend_testDot() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer(".hoge");
        ConstantAnnotationUtilTest.assertEquals((int)46, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"hoge", (String)tokenizer.getStringValue());
    }

    public void testOrdinary() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer(" hoge= 123");
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"hoge", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)61, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"123", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
    }

    public void testOrdinaryDouble() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer(" hoge= 9999.99");
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"hoge", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)61, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"9999.99", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
    }

    public void testQuote() throws Exception {
        ConstantAnnotationUtil.MyTokenizer tokenizer = new ConstantAnnotationUtil.MyTokenizer("hoge=',=abc', aaa=bbb");
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"hoge", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)61, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)39, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)",=abc", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)44, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"aaa", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)61, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((int)-3, (int)tokenizer.nextToken());
        ConstantAnnotationUtilTest.assertEquals((String)"bbb", (String)tokenizer.getStringValue());
        ConstantAnnotationUtilTest.assertEquals((int)-1, (int)tokenizer.nextToken());
    }

    public void testIsConstantAnnotation() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge.class);
        Field f1 = beanDesc.getField("A");
        ConstantAnnotationUtilTest.assertFalse((boolean)ConstantAnnotationUtil.isConstantAnnotation((Field)f1));
        Field f2 = beanDesc.getField("B");
        ConstantAnnotationUtilTest.assertFalse((boolean)ConstantAnnotationUtil.isConstantAnnotation((Field)f2));
        Field f3 = beanDesc.getField("C");
        ConstantAnnotationUtilTest.assertFalse((boolean)ConstantAnnotationUtil.isConstantAnnotation((Field)f3));
        Field f4 = beanDesc.getField("D");
        ConstantAnnotationUtilTest.assertFalse((boolean)ConstantAnnotationUtil.isConstantAnnotation((Field)f4));
        Field f5 = beanDesc.getField("F");
        ConstantAnnotationUtilTest.assertTrue((boolean)ConstantAnnotationUtil.isConstantAnnotation((Field)f5));
    }

    public static class Hoge {
        public static String A = "A";
        protected static final String B = "B";
        public String C = "C";
        public static final int D = 1;
        public static final String F = "F";
    }
}

