/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.HashMap;
import junit.framework.TestCase;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.assembler.DefaultDestroyMethodAssembler;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;

public class DefaultDestroyMethodAssemblerTest
extends TestCase {
    public void testAssemble() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        DestroyMethodDefImpl md = new DestroyMethodDefImpl("put");
        ArgDefImpl argDef = new ArgDefImpl((Object)"aaa");
        md.addArgDef((ArgDef)argDef);
        ArgDefImpl argDef2 = new ArgDefImpl((Object)"111");
        md.addArgDef((ArgDef)argDef2);
        cd.addDestroyMethodDef((DestroyMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultDestroyMethodAssembler assembler = new DefaultDestroyMethodAssembler((ComponentDef)cd);
        HashMap map = new HashMap();
        assembler.assemble(map);
        DefaultDestroyMethodAssemblerTest.assertEquals((String)"1", (Object)"111", map.get("aaa"));
    }

    public void testAssembleForExpression() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        DestroyMethodDefImpl md = new DestroyMethodDefImpl();
        md.setExpression((Expression)new OgnlExpression("#self.put('aaa', '111')"));
        cd.addDestroyMethodDef((DestroyMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultDestroyMethodAssembler assembler = new DefaultDestroyMethodAssembler((ComponentDef)cd);
        HashMap map = new HashMap();
        assembler.assemble(map);
        DefaultDestroyMethodAssemblerTest.assertEquals((String)"1", (Object)"111", map.get("aaa"));
    }

    public void testAssembleIllegalArgument() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        DestroyMethodDefImpl md = new DestroyMethodDefImpl("put");
        cd.addDestroyMethodDef((DestroyMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultDestroyMethodAssembler assembler = new DefaultDestroyMethodAssembler((ComponentDef)cd);
        HashMap map = new HashMap();
        try {
            assembler.assemble(map);
            DefaultDestroyMethodAssemblerTest.fail((String)"1");
        }
        catch (MethodNotFoundRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleWhenComponentNull() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        DestroyMethodDefImpl md = new DestroyMethodDefImpl();
        md.setExpression((Expression)new OgnlExpression("#self.put('aaa', '111')"));
        cd.addDestroyMethodDef((DestroyMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultDestroyMethodAssembler assembler = new DefaultDestroyMethodAssembler((ComponentDef)cd);
        assembler.assemble(null);
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A
    implements Foo {
        private Hoge hoge_;

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

