/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import [Ljava.lang.Object;;
import java.lang.reflect.Method;
import java.util.Collection;
import junit.framework.TestCase;
import org.seasar.framework.aop.javassist.MethodInvocationClassGenerator;
import org.seasar.framework.util.ClassPoolUtil;

public class MethodInvocationClassGeneratorTest
extends TestCase {
    public void testCreateArgumentString() throws Exception {
        MethodInvocationClassGeneratorTest.assertEquals((String)"1", (String)"((java.lang.Number) arguments[0]).intValue(), (java.lang.String) arguments[1]", (String)MethodInvocationClassGenerator.createArgumentString((Class[])new Class[]{Integer.TYPE, String.class}));
    }

    public void testCreateProceedMethodSource() throws Exception {
        Method voidMethod = Object.class.getMethod("notify", null);
        MethodInvocationClassGeneratorTest.assertEquals((String)"1", (String)"{if (interceptorsIndex < interceptors.length) {return interceptors[interceptorsIndex++].invoke(this);}((EnhancedClass) target).invokeSuper();return null;}", (String)MethodInvocationClassGenerator.createProceedMethodSource((Method)voidMethod, (String)"EnhancedClass", (String)"invokeSuper"));
        Method intMethod = Object.class.getMethod("hashCode", null);
        MethodInvocationClassGeneratorTest.assertEquals((String)"2", (String)"{if (interceptorsIndex < interceptors.length) {return interceptors[interceptorsIndex++].invoke(this);}return new java.lang.Integer(((EnhancedClass) target).invokeSuper());}", (String)MethodInvocationClassGenerator.createProceedMethodSource((Method)intMethod, (String)"EnhancedClass", (String)"invokeSuper"));
        Method stringMethod = Object.class.getMethod("toString", null);
        MethodInvocationClassGeneratorTest.assertEquals((String)"2", (String)"{if (interceptorsIndex < interceptors.length) {return interceptors[interceptorsIndex++].invoke(this);}return ((EnhancedClass) target).invokeSuper();}", (String)MethodInvocationClassGenerator.createProceedMethodSource((Method)stringMethod, (String)"EnhancedClass", (String)"invokeSuper"));
    }

    public void testCreateProceedMethodSource2() throws Exception {
        Method voidMethod = Runnable.class.getMethod("run", null);
        MethodInvocationClassGeneratorTest.assertEquals((String)"1", (String)"{if (interceptorsIndex < interceptors.length) {return interceptors[interceptorsIndex++].invoke(this);}throw new java.lang.NoSuchMethodError(\"EnhancedClass.run()\");}", (String)MethodInvocationClassGenerator.createProceedMethodSource((Method)voidMethod, (String)"EnhancedClass", (String)"invokeSuper"));
        Method intMethod = Collection.class.getMethod("size", null);
        MethodInvocationClassGeneratorTest.assertEquals((String)"2", (String)"{if (interceptorsIndex < interceptors.length) {return interceptors[interceptorsIndex++].invoke(this);}throw new java.lang.NoSuchMethodError(\"EnhancedClass.size()\");}", (String)MethodInvocationClassGenerator.createProceedMethodSource((Method)intMethod, (String)"EnhancedClass", (String)"invokeSuper"));
        Method arrayMethod = Collection.class.getMethod("toArray", Object;.class);
        MethodInvocationClassGeneratorTest.assertEquals((String)"2", (String)"{if (interceptorsIndex < interceptors.length) {return interceptors[interceptorsIndex++].invoke(this);}throw new java.lang.NoSuchMethodError(\"EnhancedClass.toArray(java.lang.Object[])\");}", (String)MethodInvocationClassGenerator.createProceedMethodSource((Method)arrayMethod, (String)"EnhancedClass", (String)"invokeSuper"));
    }

    public void testGenerateFromInterface() throws Exception {
        Method[] methods = TargetInterface.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodInvocationClassGenerator generator = new MethodInvocationClassGenerator(ClassPoolUtil.getClassPool((Class)(class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetInterface == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetInterface)), (class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetInterface == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetInterface).getName() + i, (class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass).getName());
            generator.createProceedMethod(methods[i], methods[i].getName());
            Class clazz = generator.toClass(((Object)((Object)this)).getClass().getClassLoader());
            MethodInvocationClassGeneratorTest.assertEquals((String)"1", (String)((class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetInterface == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetInterface") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetInterface).getName() + i), (String)clazz.getName());
            Method method = clazz.getDeclaredMethod("proceed", null);
            MethodInvocationClassGeneratorTest.assertEquals((String)"2", (String)"proceed", (String)method.getName());
        }
    }

    public void testGenerateFromClass() throws Exception {
        Method[] methods = TargetClass.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodInvocationClassGenerator generator = new MethodInvocationClassGenerator(ClassPoolUtil.getClassPool((Class)(class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass)), (class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass).getName() + i, (class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass).getName());
            generator.createProceedMethod(methods[i], methods[i].getName());
            Class clazz = generator.toClass(((Object)((Object)this)).getClass().getClassLoader());
            MethodInvocationClassGeneratorTest.assertEquals((String)"1", (String)((class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass == null ? MethodInvocationClassGeneratorTest.class$("org.seasar.framework.aop.javassist.MethodInvocationClassGeneratorTest$TargetClass") : class$org$seasar$framework$aop$javassist$MethodInvocationClassGeneratorTest$TargetClass).getName() + i), (String)clazz.getName());
            Method method = clazz.getDeclaredMethod("proceed", null);
            MethodInvocationClassGeneratorTest.assertEquals((String)"2", (String)"proceed", (String)method.getName());
        }
    }

    public static class TargetClass {
        public void fVoid() {
        }

        public boolean fBoolean() {
            return false;
        }

        public char fChar() {
            return '\u0000';
        }

        public byte fByte() {
            return 0;
        }

        public short fShort() {
            return 0;
        }

        public int fInt() {
            return 0;
        }

        public long fLong() {
            return 0L;
        }

        public float fFloat() {
            return 0.0f;
        }

        public double fDouble() {
            return 0.0;
        }

        public int[] fIntArray() {
            return new int[0];
        }

        public int[][] fInt2DArray() {
            return new int[0][0];
        }

        public Object fObject() {
            return null;
        }

        public Object[] fObjectArray() {
            return new Object[0];
        }

        public String fString() {
            return "";
        }

        public String[] fStringArray() {
            return new String[0];
        }

        public boolean f(boolean arg0) {
            return arg0;
        }

        public char f(char arg0) {
            return arg0;
        }

        public byte f(byte arg0) {
            return arg0;
        }

        public short f(short arg0) {
            return arg0;
        }

        public int f(int arg0) {
            return arg0;
        }

        public long f(long arg0) {
            return arg0;
        }

        public float f(float arg0) {
            return arg0;
        }

        public double f(double arg0) {
            return arg0;
        }

        public int[] f(int[] arg0) {
            return arg0;
        }

        public int[][] f(int[][] arg0) {
            return arg0;
        }

        public Object f(Object arg0) {
            return arg0;
        }

        public Object[] f(Object[] arg0) {
            return arg0;
        }

        public String f(String arg0) {
            return arg0;
        }

        public String[] f(String[] arg0) {
            return arg0;
        }

        public void f(boolean arg0, char arg1, byte arg2, short arg3, int arg4, long arg5, float arg6, double arg7, int[] arg8, int[][] arg9, Object arg10, Object[] arg11, String arg12, String[] arg13) {
        }
    }

    public static interface TargetInterface {
        public void fVoid();

        public boolean fBoolean();

        public char fChar();

        public byte fByte();

        public short fShort();

        public int fInt();

        public long fLong();

        public float fFloat();

        public double fDouble();

        public int[] fIntArray();

        public int[][] fInt2DArray();

        public Object fObject();

        public Object[] fObjectArray();

        public String fString();

        public String[] fStringArray();

        public boolean f(boolean var1);

        public char f(char var1);

        public byte f(byte var1);

        public short f(short var1);

        public int f(int var1);

        public long f(long var1);

        public float f(float var1);

        public double f(double var1);

        public int[] f(int[] var1);

        public int[][] f(int[][] var1);

        public Object f(Object var1);

        public Object[] f(Object[] var1);

        public String f(String var1);

        public String[] f(String[] var1);

        public void f(boolean var1, char var2, byte var3, short var4, int var5, long var6, float var8, double var9, int[] var11, int[][] var12, Object var13, Object[] var14, String var15, String[] var16);
    }
}

