/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.interceptors.MockInterceptor;
import org.seasar.framework.aop.proxy.AopProxy;

public class MockInterceptorTest
extends TestCase {
    public void testInvoke() throws Exception {
        MockInterceptor mi = new MockInterceptor((Object)"Hello");
        AspectImpl aspect = new AspectImpl((MethodInterceptor)mi);
        AopProxy aopProxy = new AopProxy(Hello.class, new Aspect[]{aspect});
        Hello hello = (Hello)aopProxy.create();
        MockInterceptorTest.assertEquals((String)"1", (String)"Hello", (String)hello.greeting());
    }

    public void testInvoke2() throws Exception {
        MockInterceptor mi = new MockInterceptor((Object)"Hello");
        AspectImpl aspect = new AspectImpl((MethodInterceptor)mi);
        AopProxy aopProxy = new AopProxy(Hello2.class, new Aspect[]{aspect});
        Hello2 hello = (Hello2)aopProxy.create();
        MockInterceptorTest.assertEquals((String)"1", (String)"Hello", (String)hello.echo("hoge"));
        MockInterceptorTest.assertEquals((String)"2", (boolean)true, (boolean)mi.isInvoked("echo"));
        MockInterceptorTest.assertEquals((String)"3", (boolean)false, (boolean)mi.isInvoked("greeting"));
        MockInterceptorTest.assertEquals((String)"4", (Object)"hoge", (Object)mi.getArgs("echo")[0]);
    }

    public void testInvoke3() throws Exception {
        MockInterceptor mi = new MockInterceptor();
        mi.setReturnValue("greeting", (Object)"Hello");
        mi.setReturnValue("echo", (Object)"Hello");
        AspectImpl aspect = new AspectImpl((MethodInterceptor)mi);
        AopProxy aopProxy = new AopProxy(Hello2.class, new Aspect[]{aspect});
        Hello2 hello = (Hello2)aopProxy.create();
        MockInterceptorTest.assertEquals((String)"1", (String)"Hello", (String)hello.greeting());
        MockInterceptorTest.assertEquals((String)"2", (String)"Hello", (String)hello.echo("hoge"));
    }

    public void testCreateProxy() throws Exception {
        MockInterceptor mi = new MockInterceptor((Object)"Hello");
        Hello hello = (Hello)mi.createProxy(Hello.class);
        MockInterceptorTest.assertEquals((String)"1", (String)"Hello", (String)hello.greeting());
    }

    public void testThrowable() throws Exception {
        MockInterceptor mi = new MockInterceptor();
        mi.setThrowable((Throwable)new NullPointerException());
        Hello hello = (Hello)mi.createProxy(Hello.class);
        try {
            hello.greeting();
            MockInterceptorTest.fail((String)"1");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static interface Hello2
    extends Hello {
        public String echo(String var1);
    }

    public static interface Hello {
        public String greeting();
    }
}

