/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceTraversal;
import org.seasar.framework.util.ResourceUtil;

public class ResourceTraversalTest
extends TestCase {
    private static int count = 0;

    protected void setUp() throws Exception {
        count = 0;
    }

    public void testForEachFile() throws Exception {
        File rootDir = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        String path = ResourceUtil.getResourcePath(((Object)((Object)this)).getClass());
        int pos = path.lastIndexOf("/");
        String baseDirectory = path.substring(0, pos);
        ResourceTraversal.forEach((File)rootDir, (String)baseDirectory, (ResourceTraversal.ResourceHandler)new ResourceTraversal.ResourceHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResource(String path, InputStream is) {
                try {
                    if (count < 10) {
                        System.out.println(path);
                    }
                    Assert.assertNotNull((Object)path);
                    Assert.assertNotNull((Object)is);
                    count++;
                }
                finally {
                    InputStreamUtil.close((InputStream)is);
                }
            }
        });
        ResourceTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachJarFile() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        JarURLConnection con = (JarURLConnection)classURL.openConnection();
        ResourceTraversal.forEach((JarFile)con.getJarFile(), (ResourceTraversal.ResourceHandler)new ResourceTraversal.ResourceHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResource(String path, InputStream is) {
                try {
                    if (count < 10) {
                        System.out.println(path);
                    }
                    Assert.assertNotNull((Object)path);
                    Assert.assertTrue((path.equals("META-INF/MANIFEST.MF") || path.startsWith("junit") ? 1 : 0) != 0);
                    Assert.assertNotNull((Object)is);
                    count++;
                }
                finally {
                    InputStreamUtil.close((InputStream)is);
                }
            }
        });
        ResourceTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachJarFile_withPrefix() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        JarURLConnection con = (JarURLConnection)classURL.openConnection();
        ResourceTraversal.forEach((JarFile)con.getJarFile(), (String)"junit/", (ResourceTraversal.ResourceHandler)new ResourceTraversal.ResourceHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResource(String path, InputStream is) {
                try {
                    if (count < 10) {
                        System.out.println(path);
                    }
                    Assert.assertFalse((boolean)path.startsWith("junit"));
                    Assert.assertNotNull((Object)path);
                    Assert.assertNotNull((Object)is);
                    count++;
                }
                finally {
                    InputStreamUtil.close((InputStream)is);
                }
            }
        });
        ResourceTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachZipInputStream() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        URL jarURL = new File(JarFileUtil.toJarFilePath((URL)classURL)).toURL();
        ResourceTraversal.forEach((ZipInputStream)new ZipInputStream(jarURL.openStream()), (ResourceTraversal.ResourceHandler)new ResourceTraversal.ResourceHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResource(String path, InputStream is) {
                try {
                    if (count < 10) {
                        System.out.println(path);
                    }
                    Assert.assertNotNull((Object)path);
                    Assert.assertTrue((path.equals("META-INF/MANIFEST.MF") || path.startsWith("junit") ? 1 : 0) != 0);
                    Assert.assertNotNull((Object)is);
                    count++;
                }
                finally {
                    InputStreamUtil.close((InputStream)is);
                }
            }
        });
        ResourceTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachZipInputStream_withPrefix() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        URL jarURL = new File(JarFileUtil.toJarFilePath((URL)classURL)).toURL();
        ResourceTraversal.forEach((ZipInputStream)new ZipInputStream(jarURL.openStream()), (String)"junit/", (ResourceTraversal.ResourceHandler)new ResourceTraversal.ResourceHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResource(String path, InputStream is) {
                try {
                    if (count < 10) {
                        System.out.println(path);
                    }
                    Assert.assertFalse((boolean)path.startsWith("junit"));
                    Assert.assertNotNull((Object)path);
                    Assert.assertNotNull((Object)is);
                    count++;
                }
                finally {
                    InputStreamUtil.close((InputStream)is);
                }
            }
        });
        ResourceTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }
}

