/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import ognl.OgnlContext;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.OgnlRuntimeException;
import org.seasar.framework.util.OgnlUtil;

public class OgnlUtilTest
extends TestCase {
    public void testAddClassResolverIfNecessary() {
        S2ContainerImpl container = new S2ContainerImpl(){

            public ClassLoader getClassLoader() {
                return null;
            }
        };
        Map ctx = OgnlUtil.addClassResolverIfNecessary(null, (Object)container);
        OgnlUtilTest.assertNull((String)"1", (Object)ctx);
        HashMap<String, String> origCtx = new HashMap<String, String>();
        ctx = OgnlUtil.addClassResolverIfNecessary(origCtx, (Object)container);
        OgnlUtilTest.assertSame((String)"2", origCtx, (Object)ctx);
        container = new S2ContainerImpl(){

            public ClassLoader getClassLoader() {
                return ((Object)((Object)this)).getClass().getClassLoader();
            }
        };
        ctx = OgnlUtil.addClassResolverIfNecessary(null, (Object)container);
        OgnlUtilTest.assertNotNull((String)"3", (Object)ctx);
        OgnlUtilTest.assertTrue((String)"4", (boolean)(ctx instanceof OgnlContext));
        OgnlContext octx = (OgnlContext)ctx;
        OgnlUtilTest.assertNotNull((String)"5", (Object)octx.getClassResolver());
        origCtx = new HashMap();
        origCtx.put("a", "A");
        ctx = OgnlUtil.addClassResolverIfNecessary(origCtx, (Object)container);
        OgnlUtilTest.assertNotNull((String)"6", (Object)ctx);
        OgnlUtilTest.assertTrue((String)"7", (boolean)(ctx instanceof OgnlContext));
        octx = (OgnlContext)ctx;
        OgnlUtilTest.assertNotNull((String)"8", (Object)octx.getClassResolver());
        OgnlUtilTest.assertEquals((String)"9", (Object)"A", origCtx.get("a"));
    }

    public void testClassResolverImpl() throws Exception {
        OgnlUtil.ClassResolverImpl resolver = new OgnlUtil.ClassResolverImpl(((Object)((Object)this)).getClass().getClassLoader());
        Class clazz = resolver.classForName("org.seasar.framework.container.impl.S2ContainerImpl", null);
        OgnlUtilTest.assertSame((String)"1", (Object)S2ContainerImpl.class, (Object)clazz);
        try {
            clazz = resolver.classForName("Integer", null);
        }
        catch (ClassNotFoundException ex) {
            OgnlUtilTest.fail((String)"2");
        }
        OgnlUtilTest.assertNotNull((String)"3", (Object)clazz);
    }

    public void testGetValueException() throws Exception {
        final RuntimeException runtimeException = new RuntimeException("test error message");
        Object exp = OgnlUtil.parseExpression((String)"foo.getBar()");
        HashMap<String, 3> root = new HashMap<String, 3>();
        root.put("foo", new Foo(){

            public String getBar() {
                throw runtimeException;
            }
        });
        try {
            OgnlUtil.getValue((Object)exp, root);
            OgnlUtilTest.fail();
        }
        catch (OgnlRuntimeException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            OgnlUtilTest.assertSame((Object)runtimeException, (Object)cause);
        }
    }

    public void testGetValueException2() throws Exception {
        Object exp = OgnlUtil.parseExpression((String)"hoge");
        try {
            OgnlUtil.getValue((Object)exp, (Object)new Object());
            OgnlUtilTest.fail();
        }
        catch (OgnlRuntimeException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            OgnlUtilTest.assertNotNull((Object)cause);
        }
    }

    public void testGetValue() throws Exception {
        Object exp = OgnlUtil.parseExpression((String)"new java.lang.String(\"abc\")");
        Object value = OgnlUtil.getValue((Object)exp, null);
        OgnlUtilTest.assertEquals((Object)"abc", (Object)value);
        exp = OgnlUtil.parseExpression((String)"\"aaaa\"");
        value = OgnlUtil.getValue((Object)exp, null);
        OgnlUtilTest.assertEquals((Object)"aaaa", (Object)value);
        Character a = new Character('\u3042');
        Object exp2 = OgnlUtil.parseExpression((String)("\"" + a + "\""));
        Object value2 = OgnlUtil.getValue((Object)exp2, null);
        OgnlUtilTest.assertEquals((Object)a.toString(), (Object)value2);
        exp = OgnlUtil.parseExpression((String)"a.get(\"b\")");
        HashMap<String, Integer> a2 = new HashMap<String, Integer>();
        a2.put("b", new Integer(123));
        HashMap<String, HashMap<String, Integer>> root = new HashMap<String, HashMap<String, Integer>>();
        root.put("a", a2);
        Object value3 = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)new Integer(123), (Object)value3);
        a = new Character('\u3042');
        exp2 = OgnlUtil.parseExpression((String)(a + ".get(\"b\")"));
        HashMap<String, Integer> aaa = new HashMap<String, Integer>();
        aaa.put("b", new Integer(123));
        HashMap<String, HashMap<String, Integer>> root2 = new HashMap<String, HashMap<String, Integer>>();
        root2.put(a.toString(), aaa);
        Object value4 = OgnlUtil.getValue((Object)exp2, root2);
        OgnlUtilTest.assertEquals((Object)new Integer(123), (Object)value4);
        exp = OgnlUtil.parseExpression((String)"\"aaa\" != null");
        value = OgnlUtil.getValue((Object)exp, null);
        OgnlUtilTest.assertEquals((Object)Boolean.TRUE, (Object)value);
        exp = OgnlUtil.parseExpression((String)"\"aaa\" == null");
        value = OgnlUtil.getValue((Object)exp, null);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
        exp = OgnlUtil.parseExpression((String)"a != null");
        HashMap root3 = new HashMap();
        value2 = OgnlUtil.getValue((Object)exp, root3);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value2);
        exp = OgnlUtil.parseExpression((String)"a$ == null");
        root3 = new HashMap();
        value2 = OgnlUtil.getValue((Object)exp, root3);
        OgnlUtilTest.assertEquals((Object)Boolean.TRUE, (Object)value2);
        exp = OgnlUtil.parseExpression((String)"a_ == null");
        root3 = new HashMap();
        value2 = OgnlUtil.getValue((Object)exp, root3);
        OgnlUtilTest.assertEquals((Object)Boolean.TRUE, (Object)value2);
    }

    public void testHiragana() throws Exception {
        Character a = new Character('\u3042');
        System.out.println(a);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)(a + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    public void testKatakana() throws Exception {
        Character a = new Character('\u30a2');
        System.out.println(a);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)(a + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    public void todo_testDigit() throws Exception {
        Character one = new Character('\uff11');
        System.out.println(one);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)("A" + one + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    public void todo_testSmallLetter() throws Exception {
        Character smallA = new Character('\uff41');
        System.out.println(smallA);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)(smallA + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    public void todo_testBigLetter() throws Exception {
        Character largeA = new Character('\uff21');
        System.out.println(largeA);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)(largeA + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    public void todo_testUndescore() throws Exception {
        Character underscore = new Character('\uff3f');
        System.out.println(underscore);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)(underscore + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    public void todo_testDollor() throws Exception {
        Character dollor = new Character('\uff04');
        System.out.println(dollor);
        HashMap root = new HashMap();
        Object exp = OgnlUtil.parseExpression((String)(dollor + " != null"));
        Object value = OgnlUtil.getValue((Object)exp, root);
        OgnlUtilTest.assertEquals((Object)Boolean.FALSE, (Object)value);
    }

    private static interface Foo {
        public String getBar();
    }
}

