/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import junit.framework.TestCase;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TextUtil;

public class FileUtilTest
extends TestCase {
    String root;
    File src;
    File dest;

    protected void setUp() throws Exception {
        super.setUp();
        this.root = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass()).getCanonicalPath();
        String srcTxt = this.root + "/org/seasar/framework/util/src.txt";
        this.src = new File(srcTxt);
        String destTxt = this.root + "/org/seasar/framework/util/dest.txt";
        this.dest = new File(destTxt);
    }

    protected void tearDown() throws Exception {
        if (this.dest.exists()) {
            this.dest.delete();
        }
        super.tearDown();
    }

    public void testCopy_New() throws Exception {
        FileUtilTest.assertTrue((boolean)this.src.exists());
        FileUtilTest.assertFalse((boolean)this.dest.exists());
        FileUtil.copy((File)this.src, (File)this.dest);
        FileUtilTest.assertEquals((String)TextUtil.readText((File)this.src), (String)TextUtil.readText((File)this.dest));
    }

    public void testCopy_Exists() throws Exception {
        FileUtilTest.assertTrue((boolean)this.src.exists());
        FileUtilTest.assertFalse((boolean)this.dest.exists());
        this.dest.createNewFile();
        FileUtil.copy((File)this.src, (File)this.dest);
        FileUtilTest.assertEquals((String)TextUtil.readText((File)this.src), (String)TextUtil.readText((File)this.dest));
    }
}

