/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy.creator;

import java.lang.reflect.Method;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.creator.LogicCreator;
import org.seasar.framework.container.customizer.AspectCustomizer;
import org.seasar.framework.container.hotdeploy.creator.HotdeployCreatorTestCase;
import org.seasar.framework.container.hotdeploy.creator.interceptor.HelloInterceptor;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;

public class LogicHotdeployCreatorTest
extends HotdeployCreatorTestCase {
    protected ComponentCreator newOndemandCreator(NamingConvention convention) {
        AspectCustomizer aspectCustomizer = new AspectCustomizer();
        aspectCustomizer.setInterceptorName("helloInterceptor");
        LogicCreator creator = new LogicCreator(convention);
        creator.setLogicCustomizer((ComponentCustomizer)aspectCustomizer);
        return creator;
    }

    protected void setUp() {
        this.register(HelloInterceptor.class, "helloInterceptor");
        super.setUp();
    }

    public void testIsTargetByName() throws Exception {
        String name = "cccLogic";
        ComponentDef cd = this.getComponentDef(name);
        LogicHotdeployCreatorTest.assertNotNull((String)"1", (Object)cd);
        LogicHotdeployCreatorTest.assertEquals((String)"2", (String)name, (String)cd.getComponentName());
    }

    public void testIsTargetByClass() throws Exception {
        Class clazz = ClassUtil.forName((String)(ClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".logic.CccLogic"));
        LogicHotdeployCreatorTest.assertNotNull((String)"1", (Object)this.getComponent(clazz));
    }

    public void testAspect() throws Exception {
        Object cccLogic = this.getComponent("cccLogic");
        Method m = cccLogic.getClass().getMethod("greet", null);
        LogicHotdeployCreatorTest.assertEquals((String)"1", (Object)"Hello", (Object)m.invoke(cccLogic, null));
    }
}

