/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.deployer.SessionComponentDeployer;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class SessionComponentDeployerTest
extends TestCase {
    public void testDeployAutoAutoConstructor() throws Exception {
        MockServletContextImpl ctx = new MockServletContextImpl("s2jsf-example");
        MockHttpServletRequest request = ctx.createRequest("/hello.html");
        S2ContainerImpl container = new S2ContainerImpl();
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        container.register((Object)"aaa", "hoge");
        ComponentDefImpl cd = new ComponentDefImpl(Foo.class, "foo");
        container.register((ComponentDef)cd);
        SessionComponentDeployer deployer = new SessionComponentDeployer((ComponentDef)cd);
        Foo foo = (Foo)deployer.deploy();
        SessionComponentDeployerTest.assertSame((String)"1", (Object)foo, (Object)request.getSession().getAttribute("foo"));
        SessionComponentDeployerTest.assertSame((String)"2", (Object)foo, (Object)deployer.deploy());
        SessionComponentDeployerTest.assertEquals((String)"aaa", (String)foo.getHoge());
    }

    public static class Foo {
        private String hoge;

        public void aaa() {
        }

        public String getHoge() {
            return this.hoge;
        }

        public void setHoge(String hoge) {
            this.hoge = hoge;
        }
    }
}

