/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.IllegalMethodRuntimeException;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.assembler.DefaultInitMethodAssembler;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;

public class DefaultInitMethodAssemblerTest
extends TestCase {
    public void testAssemble() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        ArgDefImpl argDef = new ArgDefImpl((Object)"aaa");
        md.addArgDef((ArgDef)argDef);
        ArgDefImpl argDef2 = new ArgDefImpl((Object)"111");
        md.addArgDef((ArgDef)argDef2);
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        HashMap map = new HashMap();
        assembler.assemble(map);
        DefaultInitMethodAssemblerTest.assertEquals((String)"1", (Object)"111", map.get("aaa"));
    }

    public void testAssembleForMethod() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl(HashMap.class.getMethod("clear", null));
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("aaa", "111");
        map.put("bbb", "222");
        assembler.assemble(map);
        DefaultInitMethodAssemblerTest.assertEquals((String)"1", (int)0, (int)map.size());
    }

    public void testAssembleForExpression() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl();
        md.setExpression((Expression)new OgnlExpression("#self.put('aaa', '111')"));
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        HashMap map = new HashMap();
        assembler.assemble(map);
        DefaultInitMethodAssemblerTest.assertEquals((String)"1", (Object)"111", map.get("aaa"));
    }

    public void testAssembleForAuto() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(B.class);
        InitMethodDefImpl md = new InitMethodDefImpl("bbb");
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        container.register(ArrayList.class);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        B b = new B();
        assembler.assemble((Object)b);
        DefaultInitMethodAssemblerTest.assertTrue((String)"1", (boolean)b.isEmpty());
    }

    public void testAssembleIllegalArgument() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        HashMap map = new HashMap();
        try {
            assembler.assemble(map);
            DefaultInitMethodAssemblerTest.fail((String)"1");
        }
        catch (MethodNotFoundRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleIllegalArgument2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(B.class);
        InitMethodDefImpl md = new InitMethodDefImpl("setAaa");
        ArgDefImpl argDef = new ArgDefImpl((Object)"aaa");
        md.addArgDef((ArgDef)argDef);
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        try {
            assembler.assemble((Object)new B());
            DefaultInitMethodAssemblerTest.fail((String)"1");
        }
        catch (IllegalMethodRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleIllegalArgument3() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(B.class);
        InitMethodDefImpl md = new InitMethodDefImpl(B.class.getMethod("getName", null));
        ArgDefImpl argDef = new ArgDefImpl((Object)"aaa");
        md.addArgDef((ArgDef)argDef);
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        try {
            assembler.assemble((Object)new B());
            DefaultInitMethodAssemblerTest.fail((String)"1");
        }
        catch (IllegalMethodRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleField() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Integer.class);
        InitMethodDefImpl md = new InitMethodDefImpl();
        md.setExpression((Expression)new OgnlExpression("#out.println(@Integer@MIN_VALUE)"));
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        assembler.assemble((Object)new Integer(1));
    }

    public void testAssembleWhenComponentNull() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Integer.class);
        InitMethodDefImpl md = new InitMethodDefImpl();
        md.setExpression((Expression)new OgnlExpression("#out.println(@Integer@MIN_VALUE)"));
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        DefaultInitMethodAssembler assembler = new DefaultInitMethodAssembler((ComponentDef)cd);
        assembler.assemble(null);
    }

    public static class B
    implements Hoge {
        private Foo foo;

        public String getName() {
            return "B";
        }

        public void setAaa(int aaa) {
        }

        public void bbb(Foo foo) {
            this.foo = foo;
        }

        public boolean isEmpty() {
            return this.foo == null;
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A
    implements Foo {
        private Hoge hoge_;

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

