/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.IllegalAutoBindingPropertyRuntimeException;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;

public class BindingTypeMustDefTest
extends TestCase {
    public void testBindExpression() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("hoge");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("hoge");
        propDef.setExpression((Expression)new OgnlExpression("hoge"));
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register(B.class, "hoge");
        A a = new A();
        BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, propDesc, (Object)a);
        BindingTypeMustDefTest.assertNotNull((String)"1", (Object)a.getHoge());
    }

    public void testBindByName() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("message");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("message");
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register((Object)"aaa", "message");
        A a = new A();
        BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, propDesc, (Object)a);
        BindingTypeMustDefTest.assertEquals((String)"1", (String)"aaa", (String)a.getMessage());
    }

    public void testBindByField() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        Field field = beanDesc.getField("message2");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("message2");
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register((Object)"aaa", "message2");
        A a = new A();
        BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, field, (Object)a);
        BindingTypeMustDefTest.assertEquals((String)"1", (String)"aaa", (String)a.getMessage2());
    }

    public void testBindByFieldNullPropertyDesc() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        Field field = beanDesc.getField("message3");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("message3");
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register((Object)"aaa", "message3");
        A a = new A();
        BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, field, (Object)a);
        BindingTypeMustDefTest.assertEquals((String)"1", (String)"aaa", (String)a.message3);
    }

    public void testBindByNameForDefferentType() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("message");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("message");
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register((Object)new Integer(1), "message");
        A a = new A();
        try {
            BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, propDesc, (Object)a);
        }
        catch (IllegalAutoBindingPropertyRuntimeException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void testBindByType() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("hoge");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("hoge");
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register(B.class);
        A a = new A();
        BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, propDesc, (Object)a);
        BindingTypeMustDefTest.assertNotNull((String)"1", (Object)a.getHoge());
    }

    public void testBindException() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)A.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("hoge");
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl propDef = new PropertyDefImpl("hoge");
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        A a = new A();
        try {
            BindingTypeDefFactory.MUST.bind((ComponentDef)cd, (PropertyDef)propDef, propDesc, (Object)a);
            BindingTypeMustDefTest.fail((String)"1");
        }
        catch (IllegalAutoBindingPropertyRuntimeException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2
    implements Foo {
        private Hoge hoge_ = new B();

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class A
    implements Foo {
        private Hoge hoge_;
        private String message_;
        private String message2;
        private String message3;

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getMessage() {
            return this.message_;
        }

        public void setMessage(String message) {
            this.message_ = message;
        }

        public String getMessage2() {
            return this.message2;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

