/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.contrib.view;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class SVRowHeader
extends JList {
    public SVRowHeader(HSSFSheet sheet, JTable table, int extraHeight) {
        SVRowHeaderModel lm = new SVRowHeaderModel(sheet);
        this.setModel(lm);
        this.setFixedCellWidth(50);
        this.setCellRenderer(new RowHeaderRenderer(sheet, table, extraHeight));
    }

    private class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        private HSSFSheet sheet;
        private int extraHeight;

        RowHeaderRenderer(HSSFSheet sheet, JTable table, int extraHeight) {
            this.sheet = sheet;
            this.extraHeight = extraHeight;
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Dimension d = this.getPreferredSize();
            int rowHeight = (int)this.sheet.getRow(index).getHeightInPoints();
            d.height = rowHeight + this.extraHeight;
            this.setPreferredSize(d);
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private class SVRowHeaderModel
    extends AbstractListModel {
        private HSSFSheet sheet;

        public SVRowHeaderModel(HSSFSheet sheet) {
            this.sheet = sheet;
        }

        public int getSize() {
            return this.sheet.getPhysicalNumberOfRows();
        }

        public Object getElementAt(int index) {
            return Integer.toString(index + 1);
        }
    }
}

