/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import junit.framework.TestCase;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.unit.UnitClassLoader;
import org.seasar.framework.util.ClassUtil;

public class MemoryLeakTest
extends TestCase {
    private static volatile int counter;
    final String basePath = ClassUtil.getPackageName(((Object)((Object)this)).getClass()).replace('.', '/') + "/";

    public void testFinalize() throws Exception {
        ClassLoader origin = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < 5; ++i) {
            TestClassLoader loader = new TestClassLoader(origin);
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)loader));
            SingletonS2ContainerFactory.setConfigPath((String)(this.basePath + "MemoryLeakTest.dicon"));
            SingletonS2ContainerFactory.init();
            SingletonS2ContainerFactory.destroy();
            Thread.currentThread().setContextClassLoader(origin);
            loader = null;
            for (int j = 0; j < 5; ++j) {
                System.gc();
                Thread.sleep(10L);
            }
            System.out.println();
        }
        for (int j = 0; j < 5; ++j) {
            System.gc();
            Thread.sleep(10L);
        }
        MemoryLeakTest.assertEquals((int)0, (int)counter);
    }

    public void testFinalizeConfigurationContainer() throws Exception {
        for (int i = 0; i < 2; ++i) {
            S2ContainerFactory.configure((String)(this.basePath + "MemoryLeakTest_configure.dicon"));
            SingletonS2ContainerFactory.setConfigPath((String)(this.basePath + "MemoryLeakTest_app.dicon"));
            SingletonS2ContainerFactory.init();
            SingletonS2ContainerFactory.destroy();
            for (int j = 0; j < 5; ++j) {
                System.gc();
                Thread.sleep(10L);
            }
            System.out.println();
        }
        this.testFinalize();
    }

    public static class TestClassLoader
    extends UnitClassLoader {
        public TestClassLoader(ClassLoader parent) {
            super(parent);
            System.out.println("+++ " + ((Object)((Object)this)).toString());
            counter++;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            System.out.println("--- " + ((Object)((Object)this)).toString());
            counter--;
        }
    }
}

