/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;

public class ComponentDefImplTest
extends TestCase {
    public void testGetComponentForType3() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        A a = (A)container.getComponent((Object)A.class);
        ComponentDefImplTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
        ComponentDefImplTest.assertSame((String)"2", (Object)a, (Object)container.getComponent((Object)A.class));
    }

    public void testGetComponentForType2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        A2 a2 = (A2)container.getComponent((Object)A2.class);
        ComponentDefImplTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testGetComponentForArgDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(BigDecimal.class, "num");
        cd.addArgDef((ArgDef)new ArgDefImpl((Object)"123"));
        container.register((ComponentDef)cd);
        ComponentDefImplTest.assertEquals((String)"1", (Object)new BigDecimal(123.0), (Object)container.getComponent((Object)"num"));
    }

    public void testGetComponentForProperyDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("hoge", (Object)new B()));
        container.register((ComponentDef)cd);
        A2 a2 = (A2)container.getComponent((Object)A2.class);
        ComponentDefImplTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testGetComponentForMethodDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class, "myMap");
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"aaa"));
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"hoge"));
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        HashMap myMap = (HashMap)container.getComponent((Object)"myMap");
        ComponentDefImplTest.assertEquals((String)"1", (Object)"hoge", myMap.get("aaa"));
    }

    public void testGetComponentForAspectDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        cd.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new TraceInterceptor()));
        container.register((ComponentDef)cd);
        container.register(B.class);
        A a = (A)container.getComponent((Object)A.class);
        ComponentDefImplTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testGetComponentForExpression() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(Object.class, "obj");
        ComponentDefImpl cd = new ComponentDefImpl(null, "hash");
        cd.setExpression((Expression)new OgnlExpression("obj.hashCode()"));
        container.register((ComponentDef)cd);
        ComponentDefImplTest.assertNotNull((String)"1", (Object)container.getComponent((Object)"hash"));
    }

    public void testCyclicReference() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(A2.class);
        container.register(C.class);
        A2 a2 = (A2)container.getComponent((Object)A2.class);
        C c = (C)container.getComponent((Object)C.class);
        ComponentDefImplTest.assertEquals((String)"1", (String)"C", (String)a2.getHogeName());
        ComponentDefImplTest.assertEquals((String)"1", (String)"C", (String)c.getHogeName());
    }

    public void testInit() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        cd.addInitMethodDef((InitMethodDef)new InitMethodDefImpl("init"));
        cd.init();
        D d = (D)cd.getComponent();
        ComponentDefImplTest.assertEquals((String)"1", (boolean)true, (boolean)d.isInited());
    }

    public void testDestroy() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        cd.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl("destroy"));
        D d = (D)cd.getComponent();
        cd.destroy();
        ComponentDefImplTest.assertEquals((String)"1", (boolean)true, (boolean)d.isDestroyed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConcreteClass() throws Exception {
        S2ContainerImpl container;
        final ClassLoader loader1 = Thread.currentThread().getContextClassLoader();
        ClassLoader loader2 = new ClassLoader(loader1){

            public Class loadClass(String name) throws ClassNotFoundException {
                if (!name.equals((class$org$seasar$framework$container$impl$ComponentDefImplTest$Foo == null ? (class$org$seasar$framework$container$impl$ComponentDefImplTest$Foo = ComponentDefImplTest.class$("org.seasar.framework.container.impl.ComponentDefImplTest$Foo")) : class$org$seasar$framework$container$impl$ComponentDefImplTest$Foo).getName())) {
                    return super.loadClass(name);
                }
                try {
                    InputStream is = loader1.getResourceAsStream(name.replace('.', '/') + ".class");
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes, 0, bytes.length);
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
        };
        Thread.currentThread().setContextClassLoader(loader2);
        try {
            container = new S2ContainerImpl();
            Class<?> fooClass = loader2.loadClass(Foo.class.getName());
            ComponentDefImpl cd = new ComponentDefImpl(fooClass, "foo");
            cd.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new TraceInterceptor()));
            container.register((ComponentDef)cd);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader1);
        }
        ComponentDefImpl cd = (ComponentDefImpl)container.getComponentDef((Object)"foo");
        Class concreteClass = cd.getConcreteClass();
        ComponentDefImplTest.assertTrue((String)"1", (boolean)concreteClass.getName().startsWith(Foo.class.getName() + "$$"));
        ComponentDefImplTest.assertEquals((String)"2", (Object)loader2, (Object)concreteClass.getClassLoader());
        Class<?> superClass = concreteClass.getInterfaces()[0];
        ComponentDefImplTest.assertEquals((String)"3", (String)Foo.class.getName(), (String)superClass.getName());
        ComponentDefImplTest.assertEquals((String)"4", (Object)loader2, (Object)superClass.getClassLoader());
    }

    public static class D {
        private boolean inited_ = false;
        private boolean destroyed_ = false;

        public boolean isInited() {
            return this.inited_;
        }

        public boolean isDestroyed() {
            return this.destroyed_;
        }

        public void init() {
            this.inited_ = true;
        }

        public void destroy() {
            this.destroyed_ = true;
        }
    }

    public static class C
    implements Hoge {
        private Foo foo_;

        public void setFoo(Foo foo) {
            this.foo_ = foo;
        }

        public String getName() {
            return "C";
        }

        public String getHogeName() {
            return this.foo_.getHogeName();
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2
    implements Foo {
        private Hoge hoge_;

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class A {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class FooImpl
    implements Foo {
        public String getHogeName() {
            return "hoge";
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

