/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy.creator;

import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.creator.DxoCreator;
import org.seasar.framework.container.customizer.AspectCustomizer;
import org.seasar.framework.container.hotdeploy.creator.HotdeployCreatorTestCase;
import org.seasar.framework.container.hotdeploy.creator.interceptor.HelloInterceptor;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;

public class DxoHotdeployCreatorTest
extends HotdeployCreatorTestCase {
    protected ComponentCreator newOndemandCreator(NamingConvention convention) {
        AspectCustomizer aspectCustomizer = new AspectCustomizer();
        aspectCustomizer.setInterceptorName("helloInterceptor");
        DxoCreator creator = new DxoCreator(convention);
        creator.setDxoCustomizer((ComponentCustomizer)aspectCustomizer);
        return creator;
    }

    protected void setUp() {
        this.register(HelloInterceptor.class, "helloInterceptor");
        super.setUp();
    }

    public void testIsTargetByComponentName() throws Exception {
        String name = "aaa_hogeDxo";
        ComponentDef cd = this.getComponentDef(name);
        DxoHotdeployCreatorTest.assertNotNull((String)"1", (Object)cd);
        DxoHotdeployCreatorTest.assertEquals((String)"2", (String)name, (String)cd.getComponentName());
        DxoHotdeployCreatorTest.assertTrue((String)"3", (boolean)this.getContainer().hasComponentDef((Object)"bbbDtoDxo"));
    }

    public void testIsTargetByClass() throws Exception {
        String packageName = ClassUtil.getPackageName(((Object)((Object)this)).getClass());
        Class clazz = ClassUtil.forName((String)(packageName + ".web.aaa.HogeDxo"));
        Class clazz2 = ClassUtil.forName((String)(packageName + ".dxo.BbbDtoDxo"));
        DxoHotdeployCreatorTest.assertTrue((String)"1", (boolean)this.getContainer().hasComponentDef((Object)clazz));
        DxoHotdeployCreatorTest.assertTrue((String)"2", (boolean)this.getContainer().hasComponentDef((Object)clazz2));
    }
}

