/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.container.autoregister.Foo;
import org.seasar.framework.container.autoregister.Foo2;
import org.seasar.framework.container.autoregister.Foo3;
import org.seasar.framework.container.autoregister.Foo4Impl;
import org.seasar.framework.container.autoregister.Foo5;
import org.seasar.framework.container.autoregister.sub.Bar2;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class FileSystemComponentAutoRegisterTest
extends S2FrameworkTestCase {
    private S2Container child;

    public void setUpRegisterAll() throws Exception {
        this.include("autoRegister.dicon");
    }

    public void testRegisterAll() throws Exception {
        Foo foo = (Foo)this.child.getComponent((Object)Foo.class);
        FileSystemComponentAutoRegisterTest.assertNotNull((Object)foo);
        Foo2 foo2 = (Foo2)this.child.getComponent((Object)Foo2.class);
        FileSystemComponentAutoRegisterTest.assertNotNull((Object)foo2);
        FileSystemComponentAutoRegisterTest.assertNotNull((Object)this.child.getComponent((Object)Foo3.class));
        FileSystemComponentAutoRegisterTest.assertSame((Object)foo2, (Object)foo.getFoo2());
        FileSystemComponentAutoRegisterTest.assertNotNull((Object)this.child.getComponent((Object)"foo3"));
        FileSystemComponentAutoRegisterTest.assertNotNull((Object)this.child.getComponent((Object)Bar2.class));
        FileSystemComponentAutoRegisterTest.assertFalse((boolean)this.child.hasComponentDef((Object)Foo4Impl.class));
    }

    public void setUpRegisterAll2() throws Exception {
        this.include("autoRegister3.dicon");
    }

    public void testRegisterAll2() throws Exception {
        ComponentDef cd = this.child.getComponentDef((Object)Foo.class);
        FileSystemComponentAutoRegisterTest.assertEquals((String)"1", (String)"prototype", (String)cd.getInstanceDef().getName());
        ComponentDef cd2 = this.child.getComponentDef((Object)Foo2.class);
        FileSystemComponentAutoRegisterTest.assertEquals((String)"2", (String)"request", (String)cd2.getInstanceDef().getName());
        FileSystemComponentAutoRegisterTest.assertNotNull((String)"3", (Object)this.child.getComponent((Object)Foo5.class));
        try {
            this.child.getComponent((Object)"foo5");
            FileSystemComponentAutoRegisterTest.fail((String)"4");
        }
        catch (TooManyRegistrationRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void setUpGetComponentDefForRoot() throws Exception {
        this.include("autoRegister.dicon");
    }

    public void testGetComponentDefForRoot() throws Exception {
        FileSystemComponentAutoRegisterTest.assertNotNull((String)"1", (Object)this.getComponentDef(Foo.class));
    }
}

