/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.S2MethodInvocation;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ClassUnmatchRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.assembler.AutoConstructorAssembler;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.exception.NoSuchConstructorRuntimeException;

public class AutoConstructorAssemblerTest
extends TestCase {
    public void testAssemble() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        A a = (A)assembler.assemble();
        AutoConstructorAssemblerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testAssembleAspect() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        cd.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new TraceInterceptor()));
        container.register((ComponentDef)cd);
        container.register(B.class);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        A a = (A)assembler.assemble();
        AutoConstructorAssemblerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testAssembleArgNotFound() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        A a = (A)assembler.assemble();
        AutoConstructorAssemblerTest.assertEquals((String)"1", null, (Object)a.getHoge());
    }

    public void testAssembleDefaultConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(String.class);
        container.register((ComponentDef)cd);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        AutoConstructorAssemblerTest.assertEquals((String)"1", (Object)"", (Object)assembler.assemble());
    }

    public void testAssembleDefaultConstructor2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge.class);
        cd.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new HogeInterceptor()));
        container.register((ComponentDef)cd);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        Hoge hoge = (Hoge)assembler.assemble();
        AutoConstructorAssemblerTest.assertEquals((String)"1", (String)"hoge", (String)hoge.getName());
    }

    public void testAssembleAutoNotInterfaceConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(C.class);
        container.register((ComponentDef)cd);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        try {
            assembler.assemble();
            AutoConstructorAssemblerTest.fail((String)"1");
        }
        catch (NoSuchConstructorRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAccessComponentDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge.class);
        ComponentDefInterceptor interceptor = new ComponentDefInterceptor();
        cd.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)interceptor));
        container.register((ComponentDef)cd);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        Hoge hoge = (Hoge)assembler.assemble();
        AutoConstructorAssemblerTest.assertEquals((String)"1", (String)"hoge", (String)hoge.getName());
        AutoConstructorAssemblerTest.assertSame((String)"2", (Object)cd, (Object)interceptor.getComponentDef());
    }

    public void testAssembleExpression() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Object.class, "obj");
        container.register((ComponentDef)cd);
        ComponentDefImpl cd2 = new ComponentDefImpl();
        cd2.setExpression((Expression)new OgnlExpression("obj.hashCode()"));
        container.register((ComponentDef)cd2);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd2);
        Integer myInt = (Integer)assembler.assemble();
        AutoConstructorAssemblerTest.assertNotNull((String)"1", (Object)myInt);
    }

    public void testAssembleForClassUnmatch() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Object.class, "obj");
        cd.setExpression((Expression)new OgnlExpression("null"));
        container.register((ComponentDef)cd);
        AutoConstructorAssembler assembler = new AutoConstructorAssembler((ComponentDef)cd);
        try {
            assembler.assemble();
            AutoConstructorAssemblerTest.fail((String)"1");
        }
        catch (ClassUnmatchRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public class ComponentDefInterceptor
    implements MethodInterceptor {
        private ComponentDef componentDef_;

        public ComponentDef getComponentDef() {
            return this.componentDef_;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            S2MethodInvocation impl = (S2MethodInvocation)invocation;
            this.componentDef_ = (ComponentDef)impl.getParameter("componentDef");
            return "hoge";
        }
    }

    public class HogeInterceptor
    implements MethodInterceptor {
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return "hoge";
        }
    }

    public static class C {
        private String name_;

        public C(String name) {
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A
    implements Foo {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public Hoge getHoge() {
            return this.hoge_;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

