/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import junit.framework.TestCase;
import org.seasar.framework.aop.javassist.TryBlockSupport;

public class TryBlockSupportTest
extends TestCase {
    public void testCatch() throws Exception {
        TryBlockSupport tryBlock = new TryBlockSupport("return null;");
        tryBlock.addCatchBlock(Exception.class, "e.printStackTrace();");
        tryBlock.addCatchBlock(Error.class, "");
        TryBlockSupportTest.assertEquals((String)"1", (String)"try {return null;}catch (java.lang.Exception e) {e.printStackTrace();}catch (java.lang.Error e) {}", (String)tryBlock.getSourceCode());
    }

    public void testFinally() throws Exception {
        TryBlockSupport tryBlock = new TryBlockSupport("return null;");
        tryBlock.setFinallyBlock("System.out.println();");
        TryBlockSupportTest.assertEquals((String)"1", (String)"try {return null;}finally {System.out.println();}", (String)tryBlock.getSourceCode());
    }

    public void testCatchFinally() throws Exception {
        TryBlockSupport tryBlock = new TryBlockSupport("return null;");
        tryBlock.addCatchBlock(Exception.class, "e.printStackTrace();");
        tryBlock.addCatchBlock(Error.class, "");
        tryBlock.setFinallyBlock("System.out.println();");
        TryBlockSupportTest.assertEquals((String)"1", (String)"try {return null;}catch (java.lang.Exception e) {e.printStackTrace();}catch (java.lang.Error e) {}finally {System.out.println();}", (String)tryBlock.getSourceCode());
    }

    public void testFail() throws Exception {
        TryBlockSupport tryBlock = new TryBlockSupport("return null;");
        try {
            tryBlock.getSourceCode();
            TryBlockSupportTest.fail((String)"1");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        tryBlock.setFinallyBlock("");
        try {
            tryBlock.addCatchBlock(Exception.class, "");
            TryBlockSupportTest.fail((String)"1");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            tryBlock.setFinallyBlock("");
            TryBlockSupportTest.fail((String)"1");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNotThrowable() throws Exception {
        TryBlockSupport tryBlock = new TryBlockSupport("return null;");
        try {
            tryBlock.addCatchBlock(Object.class, "");
            TryBlockSupportTest.fail((String)"1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

