/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.intertype;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.seasar.framework.aop.intertype.PropertyInterTypeTarget;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;

public abstract class AbstractPropertyInterTypeTest
extends TestCase {
    private PropertyInterTypeTarget target;
    private Class targetClass;
    private Object target2;
    private Class targetClass2;
    private Object testObject;

    protected abstract String getPath();

    public AbstractPropertyInterTypeTest() {
    }

    public AbstractPropertyInterTypeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        S2Container container = S2ContainerFactory.create((String)this.getPath());
        this.target = (PropertyInterTypeTarget)container.getComponent((Object)"target");
        this.targetClass = this.target.getClass();
        this.target2 = container.getComponent((Object)"target2");
        this.targetClass2 = this.target2.getClass();
        this.testObject = container.getComponent((Object)"testObject");
    }

    public void testSetterGetter() throws Exception {
        AbstractPropertyInterTypeTest.assertEquals((int)this.getIntField("getIntReadField"), (int)123);
        this.setIntField("setIntWriteField", 456);
        AbstractPropertyInterTypeTest.assertEquals((int)this.target.getIntWriteField(), (int)456);
        this.setIntField("setIntReadWriteField", 789);
        AbstractPropertyInterTypeTest.assertEquals((int)this.getIntField("getIntReadWriteField"), (int)789);
    }

    public void testFieldType() throws Exception {
        Object testValue1 = new Object();
        this.setField("setObjectField", testValue1);
        AbstractPropertyInterTypeTest.assertEquals((Object)this.getField("getObjectField"), (Object)testValue1);
        String[] testValue2 = new String[]{"apple", "orange", "lemon"};
        this.setField("setStringArrayField", testValue2);
        AbstractPropertyInterTypeTest.assertEquals((Object)this.getField("getStringArrayField"), (Object)testValue2);
        long[][] testValue3 = new long[][]{{123L, 456L, 789L}, {123L, 456L, 789L}};
        this.setField("setLongArrayField", testValue3);
        AbstractPropertyInterTypeTest.assertEquals((Object)this.getField("getLongArrayField"), (Object)testValue3);
    }

    public void testModifier() throws Exception {
        this.assertMethodExists("getPublicField");
        this.assertMethodExists("setPublicField", Integer.TYPE);
        this.assertMethodExists("getProtectedField");
        this.assertMethodExists("setProtectedField", Integer.TYPE);
        this.assertMethodNotExists("getPrivateField");
        this.assertMethodNotExists("setPrivateField", Integer.TYPE);
        this.assertMethodNotExists("getIntNoneField");
        this.assertMethodNotExists("setIntNoneField", Integer.TYPE);
        this.assertMethodNotExists("getNonAnnotatedField");
        this.assertMethodNotExists("setNonAnnotatedField", Integer.TYPE);
    }

    public void testClassAnnotated() throws Exception {
        this.assertMethodExists(this.targetClass2, "getDefaultField");
        this.assertMethodExists(this.targetClass2, "setDefaultField", Integer.TYPE);
        this.assertMethodExists(this.targetClass2, "getReadField");
        this.assertMethodNotExists(this.targetClass2, "setReadField", Integer.TYPE);
        this.assertMethodNotExists(this.targetClass2, "getWriteField");
        this.assertMethodExists(this.targetClass2, "setWriteField", Integer.TYPE);
        this.assertMethodExists(this.targetClass2, "getReadWriteField");
        this.assertMethodExists(this.targetClass2, "setReadWriteField", Integer.TYPE);
        this.assertMethodNotExists(this.targetClass2, "getNoneField");
        this.assertMethodNotExists(this.targetClass2, "setNoneField", Integer.TYPE);
    }

    public void testHasMethod() throws Exception {
        this.assertMethodNotExists(this.targetClass2, "getHasGetter");
        this.assertMethodExists(this.targetClass2, "setHasGetter", Integer.TYPE);
        this.assertMethodExists(this.targetClass2, "getHasSetter");
        this.assertMethodNotExists(this.targetClass2, "setHasSetter", Integer.TYPE);
        this.assertMethodNotExists(this.targetClass2, "getHasGetterSetter");
        this.assertMethodNotExists(this.targetClass2, "setHasGetterSetter", Integer.TYPE);
    }

    public void testInjection() {
        BeanDesc desc = BeanDescFactory.getBeanDesc((Class)this.targetClass);
        PropertyDesc pd = desc.getPropertyDesc("testObject");
        AbstractPropertyInterTypeTest.assertEquals((Object)this.testObject, (Object)pd.getValue((Object)this.target));
    }

    private void setIntField(String methodName, int param) {
        Method setter = ClassUtil.getMethod((Class)this.targetClass, (String)methodName, (Class[])new Class[]{Integer.TYPE});
        MethodUtil.invoke((Method)setter, (Object)this.target, (Object[])new Object[]{new Integer(param)});
    }

    private int getIntField(String methodName) {
        Method getter = ClassUtil.getMethod((Class)this.targetClass, (String)methodName, null);
        Integer value = (Integer)MethodUtil.invoke((Method)getter, (Object)this.target, null);
        return value;
    }

    private void setField(String methodName, Object param) {
        Method setter = ClassUtil.getMethod((Class)this.targetClass, (String)methodName, (Class[])new Class[]{param.getClass()});
        MethodUtil.invoke((Method)setter, (Object)this.target, (Object[])new Object[]{param});
    }

    private Object getField(String methodName) {
        Method getter = ClassUtil.getMethod((Class)this.targetClass, (String)methodName, null);
        Object value = MethodUtil.invoke((Method)getter, (Object)this.target, null);
        return value;
    }

    private void assertMethodExists(String methodName) {
        this.assertMethodExists(methodName, null);
    }

    private void assertMethodExists(String methodName, Class paramType) {
        this.assertMethodExists(this.targetClass, methodName, paramType);
    }

    private void assertMethodExists(Class targetClass, String methodName) {
        this.assertMethodExists(targetClass, methodName, null);
    }

    private void assertMethodExists(Class targetClass, String methodName, Class paramType) {
        Class[] param = null;
        if (paramType != null) {
            param = new Class[]{paramType};
        }
        ClassUtil.getDeclaredMethod((Class)targetClass, (String)methodName, param);
        AbstractPropertyInterTypeTest.assertNotNull((Object)methodName);
    }

    private void assertMethodNotExists(String methodName) {
        this.assertMethodNotExists(methodName, null);
    }

    private void assertMethodNotExists(String methodName, Class paramType) {
        this.assertMethodNotExists(this.targetClass, methodName, paramType);
    }

    private void assertMethodNotExists(Class targetClass, String methodName) {
        this.assertMethodNotExists(targetClass, methodName, null);
    }

    private void assertMethodNotExists(Class targetClass, String methodName, Class paramType) {
        Class[] param = null;
        if (paramType != null) {
            param = new Class[]{paramType};
        }
        try {
            ClassUtil.getDeclaredMethod((Class)targetClass, (String)methodName, param);
            AbstractPropertyInterTypeTest.fail((String)("The method " + methodName + " exsts."));
        }
        catch (NoSuchMethodRuntimeException e) {
            // empty catch block
        }
    }
}

