/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class OrderByList
extends OrderedColumnList
implements RequiredRowOrdering {
    private boolean allAscending = true;
    private boolean alwaysSort;
    private ResultSetNode resultToSort;
    private SortCostController scc;
    private Object[] resultRow;
    private ColumnOrdering[] columnOrdering;
    private int estimatedRowSize;
    private boolean sortNeeded = true;

    public void addOrderByColumn(OrderByColumn orderByColumn) {
        this.addElement(orderByColumn);
        if (!orderByColumn.isAscending()) {
            this.allAscending = false;
        }
    }

    boolean allAscending() {
        return this.allAscending;
    }

    public OrderByColumn getOrderByColumn(int n) {
        return (OrderByColumn)this.elementAt(n);
    }

    public void printSubNodes(int n) {
    }

    public void bindOrderByColumns(ResultSetNode resultSetNode) throws StandardException {
        this.resultToSort = resultSetNode;
        int n = this.size();
        if (n > 1012) {
            throw StandardException.newException("54004");
        }
        for (int i = 0; i < n; ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            orderByColumn.bindOrderByColumn(resultSetNode, this);
            if (orderByColumn.getResultColumn().getExpression() instanceof ColumnReference) continue;
            this.alwaysSort = true;
        }
    }

    void closeGap(int n) {
        for (int i = 0; i < this.size(); ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            orderByColumn.collapseAddedColumnGap(n);
        }
    }

    public void pullUpOrderByColumns(ResultSetNode resultSetNode) throws StandardException {
        this.resultToSort = resultSetNode;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            orderByColumn.pullUpOrderByColumn(resultSetNode);
        }
    }

    boolean isInOrderPrefix(ResultColumnList resultColumnList) {
        boolean bl = true;
        int n = resultColumnList.size();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (((OrderByColumn)this.elementAt(i)).getResultColumn() == (ResultColumn)resultColumnList.elementAt(i)) continue;
            return false;
        }
        return true;
    }

    void resetToSourceRCs() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            orderByColumn.resetToSourceRC();
        }
    }

    ResultColumnList reorderRCL(ResultColumnList resultColumnList) throws StandardException {
        ResultColumnList resultColumnList2 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            resultColumnList2.addElement(orderByColumn.getResultColumn());
            resultColumnList.removeElement(orderByColumn.getResultColumn());
        }
        resultColumnList2.destructiveAppend(resultColumnList);
        resultColumnList2.resetVirtualColumnIds();
        resultColumnList2.copyOrderBySelect(resultColumnList);
        return resultColumnList2;
    }

    void removeConstantColumns(PredicateList predicateList) {
        for (int i = this.size() - 1; i >= 0; --i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            if (!orderByColumn.constantColumn(predicateList)) continue;
            this.removeElementAt(i);
        }
    }

    void removeDupColumns() {
        block0: for (int i = this.size() - 1; i > 0; --i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            int n = orderByColumn.getColumnPosition();
            for (int j = 0; j < i; ++j) {
                OrderByColumn orderByColumn2 = (OrderByColumn)this.elementAt(j);
                if (n != orderByColumn2.getColumnPosition()) continue;
                this.removeElementAt(i);
                continue block0;
            }
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, ResultSetNode resultSetNode) throws StandardException {
        if (!this.sortNeeded) {
            resultSetNode.generate(activationClassBuilder, methodBuilder);
            return;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        int n = activationClassBuilder.addItem(activationClassBuilder.getColumnOrdering(this));
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        resultSetNode.generate(activationClassBuilder, methodBuilder);
        int n2 = compilerContext.getNextResultSetNumber();
        methodBuilder.push(false);
        methodBuilder.push(false);
        methodBuilder.push(n);
        resultSetNode.getResultColumns().generateHolder(activationClassBuilder, methodBuilder);
        methodBuilder.push(resultSetNode.getResultColumns().getTotalColumnSize());
        methodBuilder.push(n2);
        CostEstimate costEstimate = resultSetNode.getFinalCostEstimate();
        methodBuilder.push(costEstimate.rowCount());
        methodBuilder.push(costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }

    public int sortRequired(RowOrdering rowOrdering) throws StandardException {
        return this.sortRequired(rowOrdering, null);
    }

    public int sortRequired(RowOrdering rowOrdering, JBitSet jBitSet) throws StandardException {
        if (this.alwaysSort) {
            return 1;
        }
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            OrderByColumn orderByColumn = this.getOrderByColumn(i);
            ValueNode valueNode = orderByColumn.getResultColumn().getExpression();
            if (!(valueNode instanceof ColumnReference)) {
                return 1;
            }
            ColumnReference columnReference = (ColumnReference)valueNode;
            if (jBitSet != null && !jBitSet.get(columnReference.getTableNumber())) {
                for (int j = i + 1; j < this.size(); ++j) {
                    ColumnReference columnReference2;
                    OrderByColumn orderByColumn2 = this.getOrderByColumn(i);
                    ResultColumn resultColumn = orderByColumn2.getResultColumn();
                    ValueNode valueNode2 = resultColumn.getExpression();
                    if (!(valueNode2 instanceof ColumnReference) || !jBitSet.get((columnReference2 = (ColumnReference)valueNode2).getTableNumber())) continue;
                    return 1;
                }
                return 3;
            }
            if (rowOrdering.alwaysOrdered(columnReference.getTableNumber())) continue;
            if (!rowOrdering.orderedOnColumn(orderByColumn.isAscending() ? 1 : 2, n, columnReference.getTableNumber(), columnReference.getColumnNumber())) {
                return 1;
            }
            ++n;
        }
        return 3;
    }

    public void estimateCost(double d, RowOrdering rowOrdering, CostEstimate costEstimate) throws StandardException {
        long l;
        if (this.scc == null) {
            this.scc = this.getCompilerContext().getSortCostController();
            this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
            this.columnOrdering = this.getColumnOrdering();
            this.estimatedRowSize = this.resultToSort.getResultColumns().getTotalColumnSize();
        }
        long l2 = l = (long)d;
        double d2 = this.scc.getSortCost((DataValueDescriptor[])this.resultRow, this.columnOrdering, false, l, l2, this.estimatedRowSize);
        costEstimate.setCost(d2, d, d);
    }

    public void sortNeeded() {
        this.sortNeeded = true;
    }

    public void sortNotNeeded() {
        this.sortNeeded = false;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
    }

    public boolean getSortNeeded() {
        return this.sortNeeded;
    }
}

