/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement40;
import org.apache.derby.iapi.jdbc.BrokeredConnection30;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement40;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement40;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.FailedProperties40;
import org.apache.derby.impl.jdbc.Util;

public class BrokeredConnection40
extends BrokeredConnection30 {
    public BrokeredConnection40(BrokeredConnectionControl brokeredConnectionControl) {
        super(brokeredConnectionControl);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            return this.getRealConnection().createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
        try {
            return this.getRealConnection().createBlob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
        try {
            return this.getRealConnection().createClob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.getRealConnection().createNClob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.getRealConnection().createSQLXML();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        try {
            return this.getRealConnection().createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.getRealConnection().isValid(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.notifyException(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), new FailedProperties40(FailedProperties40.makeProperties(string, string2)).getProperties());
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.notifyException(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            return this.getRealConnection().getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getRealConnection().getClientInfo();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final BrokeredStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        try {
            return new BrokeredStatement40(brokeredStatementControl, this.getJDBCLevel());
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string, Object object) throws SQLException {
        try {
            return new BrokeredPreparedStatement40(brokeredStatementControl, this.getJDBCLevel(), string, object);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string) throws SQLException {
        try {
            return new BrokeredCallableStatement40(brokeredStatementControl, this.getJDBCLevel(), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    final int getJDBCLevel() {
        return 4;
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkIfClosed();
        return clazz.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkIfClosed();
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException("XJ128.S", clazz);
        }
    }
}

