/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class RegexpFactory
extends RegexpMatcherFactory {
    public Regexp newRegexp() throws BuildException {
        return this.newRegexp(null);
    }

    public Regexp newRegexp(Project p) throws BuildException {
        String systemDefault = null;
        systemDefault = p == null ? System.getProperty("ant.regexp.regexpimpl") : p.getProperty("ant.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createRegexpInstance(systemDefault);
        }
        Throwable cause = null;
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createRegexpInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpRegexp");
        }
        catch (BuildException be) {
            cause = RegexpFactory.orCause(cause, be, JavaEnvUtils.getJavaVersionNumber() < 14);
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaOroRegexp");
            }
            catch (BuildException be2) {
                cause = RegexpFactory.orCause(cause, be2, true);
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaRegexpRegexp");
                }
                catch (BuildException be3) {
                    cause = RegexpFactory.orCause(cause, be3, true);
                    throw new BuildException("No supported regular expression matcher found" + (cause != null ? ": " + cause : ""), cause);
                }
            }
        }
    }

    protected Regexp createRegexpInstance(String classname) throws BuildException {
        RegexpMatcher m = this.createInstance(classname);
        if (m instanceof Regexp) {
            return (Regexp)m;
        }
        throw new BuildException(classname + " doesn't implement the Regexp interface");
    }
}

