/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.Tool;

public class DeleteDbFiles
extends Tool {
    private void showUsage() {
        this.out.println("Deletes all files belonging to a database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-dir <dir>]      The directory (default: .)\n" + " [-db <database>]  The database name\n" + " [-quiet]          Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new DeleteDbFiles().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.equals("-dir")) {
                string = stringArray[++i];
                continue;
            }
            if (string3.equals("-db")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string3.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string3);
            this.showUsage();
            return;
        }
        this.process(string, string2, bl);
    }

    public static void execute(String string, String string2, boolean bl) throws SQLException {
        new DeleteDbFiles().process(string, string2, bl);
    }

    private void process(String string, String string2, boolean bl) throws SQLException {
        DeleteDbFiles deleteDbFiles = new DeleteDbFiles();
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0 && !bl) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            deleteDbFiles.process(string3, bl);
            if (bl) continue;
            this.out.println("Processed: " + string3);
        }
    }

    private void process(String string, boolean bl) throws SQLException {
        if (bl || string.endsWith(".temp.db") || string.endsWith(".trace.db")) {
            FileUtils.tryDelete(string);
        } else {
            FileUtils.delete(string);
        }
    }
}

