/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.seasar.framework.util.SLinkedList;
import org.seasar.framework.util.SerializeUtil;

public class SLinkedListTest
extends TestCase {
    private SLinkedList list_;

    public void testGetFirstEntry() throws Exception {
        SLinkedListTest.assertNull((String)"1", (Object)this.list_.getFirstEntry());
        this.list_.addFirst((Object)"1");
        SLinkedListTest.assertEquals((String)"2", (Object)"1", (Object)this.list_.getFirstEntry().getElement());
    }

    public void testGetFirst() throws Exception {
        try {
            this.list_.getFirst();
            SLinkedListTest.fail((String)"1");
        }
        catch (NoSuchElementException ex) {
            System.out.println(ex);
        }
        this.list_.addFirst((Object)"1");
        SLinkedListTest.assertEquals((String)"2", (Object)"1", (Object)this.list_.getFirst());
    }

    public void testGetLastEntry() throws Exception {
        SLinkedListTest.assertNull((String)"1", (Object)this.list_.getLastEntry());
        this.list_.addLast((Object)"1");
        SLinkedListTest.assertEquals((String)"2", (Object)"1", (Object)this.list_.getLastEntry().getElement());
    }

    public void testGetLast() throws Exception {
        try {
            this.list_.getLast();
            SLinkedListTest.fail((String)"1");
        }
        catch (NoSuchElementException ex) {
            System.out.println(ex);
        }
        this.list_.addLast((Object)"1");
        SLinkedListTest.assertEquals((String)"2", (Object)"1", (Object)this.list_.getLast());
    }

    public void testRemoveFirst() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.removeFirst();
        SLinkedListTest.assertEquals((String)"1", (Object)"2", (Object)this.list_.getFirst());
    }

    public void testRemoveLast() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.removeLast();
        SLinkedListTest.assertEquals((String)"1", (Object)"1", (Object)this.list_.getLast());
    }

    public void testAddFirst() throws Exception {
        this.list_.addFirst((Object)"1");
        this.list_.addFirst((Object)"2");
        SLinkedListTest.assertEquals((String)"1", (Object)"2", (Object)this.list_.getFirst());
    }

    public void testAddLast() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        SLinkedListTest.assertEquals((String)"1", (Object)"2", (Object)this.list_.getLast());
    }

    public void testSize() throws Exception {
        SLinkedListTest.assertEquals((String)"1", (int)0, (int)this.list_.size());
        this.list_.addLast((Object)"1");
        SLinkedListTest.assertEquals((String)"2", (int)1, (int)this.list_.size());
        this.list_.removeFirst();
        SLinkedListTest.assertEquals((String)"3", (int)0, (int)this.list_.size());
    }

    public void testIsEmpty() throws Exception {
        SLinkedListTest.assertTrue((String)"1", (boolean)this.list_.isEmpty());
        this.list_.addLast((Object)"1");
        SLinkedListTest.assertTrue((String)"2", (!this.list_.isEmpty() ? 1 : 0) != 0);
    }

    public void testContaines() throws Exception {
        SLinkedListTest.assertTrue((String)"1", (!this.list_.contains(null) ? 1 : 0) != 0);
        SLinkedListTest.assertTrue((String)"2", (!this.list_.contains((Object)"1") ? 1 : 0) != 0);
        this.list_.addLast((Object)"1");
        SLinkedListTest.assertTrue((String)"3", (boolean)this.list_.contains((Object)"1"));
        SLinkedListTest.assertTrue((String)"4", (!this.list_.contains((Object)"2") ? 1 : 0) != 0);
        SLinkedListTest.assertTrue((String)"5", (!this.list_.contains(null) ? 1 : 0) != 0);
    }

    public void testRemove() throws Exception {
        this.list_.addLast(null);
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        SLinkedListTest.assertTrue((String)"1", (!this.list_.remove((Object)"3") ? 1 : 0) != 0);
        SLinkedListTest.assertTrue((String)"2", (boolean)this.list_.remove((Object)"1"));
        SLinkedListTest.assertTrue((String)"3", (boolean)this.list_.remove(null));
        this.list_.clear();
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        this.list_.remove(1);
        SLinkedListTest.assertEquals((String)"1", (Object)"1", (Object)this.list_.get(0));
        SLinkedListTest.assertEquals((String)"2", (Object)"3", (Object)this.list_.get(1));
        this.list_.clear();
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        SLinkedList.Entry e = this.list_.getEntry(1);
        e.remove();
        SLinkedListTest.assertEquals((String)"3", (Object)"3", (Object)e.getNext().getElement());
    }

    public void testClear() throws Exception {
        this.list_.addLast(null);
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.clear();
        SLinkedListTest.assertEquals((String)"1", (int)0, (int)this.list_.size());
        SLinkedListTest.assertNull((String)"2", (Object)this.list_.getFirstEntry());
        SLinkedListTest.assertNull((String)"3", (Object)this.list_.getLastEntry());
    }

    public void testGetEntry() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        SLinkedListTest.assertEquals((String)"1", (Object)"1", (Object)this.list_.getEntry(0).getElement());
        SLinkedListTest.assertEquals((String)"2", (Object)"2", (Object)this.list_.getEntry(1).getElement());
        SLinkedListTest.assertEquals((String)"3", (Object)"3", (Object)this.list_.getEntry(2).getElement());
        try {
            this.list_.getEntry(-1);
            SLinkedListTest.fail((String)"4");
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println(ex);
        }
        try {
            this.list_.getEntry(3);
            SLinkedListTest.fail((String)"5");
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println(ex);
        }
    }

    public void testGet() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        SLinkedListTest.assertEquals((String)"1", (Object)"1", (Object)this.list_.get(0));
        SLinkedListTest.assertEquals((String)"2", (Object)"2", (Object)this.list_.get(1));
        SLinkedListTest.assertEquals((String)"3", (Object)"3", (Object)this.list_.get(2));
    }

    public void testSerialize() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        SLinkedListTest.assertNotNull((String)"1", (Object)SerializeUtil.serialize((Object)this.list_));
    }

    public void testSet() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        this.list_.set(1, (Object)"4");
        SLinkedListTest.assertEquals((String)"1", (Object)"4", (Object)this.list_.get(1));
    }

    public void testEntry() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        SLinkedList.Entry e = this.list_.getFirstEntry();
        SLinkedListTest.assertNull((String)"1", (Object)e.getPrevious());
        SLinkedListTest.assertEquals((String)"2", (Object)"2", (Object)e.getNext().getElement());
        e = this.list_.getLastEntry();
        SLinkedListTest.assertNull((String)"3", (Object)e.getNext());
        SLinkedListTest.assertEquals((String)"4", (Object)"2", (Object)e.getPrevious().getElement());
        this.list_.getEntry(1).remove();
        SLinkedListTest.assertEquals((String)"5", (Object)"1", (Object)this.list_.getFirst());
        SLinkedListTest.assertEquals((String)"6", (Object)"3", (Object)this.list_.getLast());
        this.list_.getLastEntry().remove();
        SLinkedListTest.assertEquals((String)"7", (Object)"1", (Object)this.list_.getLast());
        this.list_.getLastEntry().remove();
        SLinkedListTest.assertEquals((String)"8", (int)0, (int)this.list_.size());
    }

    public void testAdd() throws Exception {
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        this.list_.add(1, (Object)"4");
        SLinkedListTest.assertEquals((String)"1", (Object)"4", (Object)this.list_.get(1));
        SLinkedListTest.assertEquals((String)"2", (Object)"2", (Object)this.list_.get(2));
    }

    public void testIndexOf() throws Exception {
        this.list_.addLast(null);
        this.list_.addLast((Object)"1");
        this.list_.addLast((Object)"2");
        this.list_.addLast((Object)"3");
        SLinkedListTest.assertEquals((String)"1", (int)0, (int)this.list_.indexOf(null));
        SLinkedListTest.assertEquals((String)"2", (int)1, (int)this.list_.indexOf((Object)"1"));
        SLinkedListTest.assertEquals((String)"3", (int)2, (int)this.list_.indexOf((Object)"2"));
        SLinkedListTest.assertEquals((String)"4", (int)3, (int)this.list_.indexOf((Object)"3"));
        SLinkedListTest.assertEquals((String)"5", (int)-1, (int)this.list_.indexOf((Object)"4"));
    }

    protected void setUp() throws Exception {
        this.list_ = new SLinkedList();
    }

    protected void tearDown() throws Exception {
        this.list_.clear();
        this.list_ = null;
    }
}

