/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.assembler.DefaultConstructorConstructorAssembler;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.exception.OgnlRuntimeException;

public class DefaultConstructorConstructorAssemblerTest
extends TestCase {
    public void testAssemble() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(ArrayList.class);
        container.register((ComponentDef)cd);
        DefaultConstructorConstructorAssembler assempbler = new DefaultConstructorConstructorAssembler((ComponentDef)cd);
        DefaultConstructorConstructorAssemblerTest.assertNotNull((String)"1", (Object)assempbler.assemble());
    }

    public void testAssembleAspect() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(ArrayList.class);
        cd.addAspectDef((AspectDef)new AspectDefImpl((MethodInterceptor)new TraceInterceptor()));
        container.register((ComponentDef)cd);
        DefaultConstructorConstructorAssembler assempbler = new DefaultConstructorConstructorAssembler((ComponentDef)cd);
        List list = (List)assempbler.assemble();
        list.size();
    }

    public void testAssembleManual() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        ArgDefImpl argDef = new ArgDefImpl((Object)new B());
        cd.addArgDef((ArgDef)argDef);
        container.register((ComponentDef)cd);
        DefaultConstructorConstructorAssembler assembler = new DefaultConstructorConstructorAssembler((ComponentDef)cd);
        A a = (A)assembler.assemble();
        DefaultConstructorConstructorAssemblerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testAssembleIllegalConstructorArgument() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        ArgDefImpl argDef = new ArgDefImpl();
        argDef.setExpression((Expression)new OgnlExpression("hoge"));
        cd.addArgDef((ArgDef)argDef);
        container.register((ComponentDef)cd);
        DefaultConstructorConstructorAssembler assembler = new DefaultConstructorConstructorAssembler((ComponentDef)cd);
        try {
            assembler.assemble();
            DefaultConstructorConstructorAssemblerTest.fail((String)"1");
        }
        catch (OgnlRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A
    implements Foo {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public Hoge getHoge() {
            return this.hoge_;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

