/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.InterType;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.javassist.AspectWeaver;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.MethodUtil;

public class AopProxy
implements Serializable {
    static final long serialVersionUID = 0L;
    private static Logger logger = Logger.getLogger(AopProxy.class);
    private final Class targetClass;
    private final Class enhancedClass;
    private final Pointcut defaultPointcut;
    private final AspectWeaver weaver;

    public AopProxy(Class targetClass, Aspect[] aspects) {
        this(targetClass, aspects, null, null);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, InterType[] interTypes) {
        this(targetClass, aspects, interTypes, null);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, Map parameters) {
        this(targetClass, aspects, null, parameters);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, InterType[] interTypes, Map parameters) {
        if (!(aspects != null && aspects.length != 0 || interTypes != null && interTypes.length != 0)) {
            throw new EmptyRuntimeException("aspects and interTypes");
        }
        this.targetClass = targetClass;
        this.defaultPointcut = new PointcutImpl(targetClass);
        this.weaver = new AspectWeaver(targetClass, parameters);
        this.setupAspects(aspects);
        this.weaver.setInterTypes(interTypes);
        this.enhancedClass = this.weaver.generateClass();
    }

    private void setupAspects(Aspect[] aspects) {
        if (aspects == null || aspects.length == 0) {
            return;
        }
        for (int i = 0; i < aspects.length; ++i) {
            Aspect aspect = aspects[i];
            if (aspect.getPointcut() != null) continue;
            aspect.setPointcut(this.defaultPointcut);
        }
        Method[] methods = this.targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (MethodUtil.isBridgeMethod(method) || MethodUtil.isSyntheticMethod(method)) continue;
            ArrayList<MethodInterceptor> interceptorList = new ArrayList<MethodInterceptor>();
            for (int j = 0; j < aspects.length; ++j) {
                Aspect aspect = aspects[j];
                if (!aspect.getPointcut().isApplied(method)) continue;
                interceptorList.add(aspect.getMethodInterceptor());
            }
            if (interceptorList.size() == 0) continue;
            if (!this.isApplicableAspect(method)) {
                logger.log("WSSR0009", new Object[]{this.targetClass.getName(), method.getName()});
                continue;
            }
            this.weaver.setInterceptors(method, interceptorList.toArray(new MethodInterceptor[interceptorList.size()]));
        }
    }

    public Class getEnhancedClass() {
        return this.enhancedClass;
    }

    public Object create() {
        return ClassUtil.newInstance(this.enhancedClass);
    }

    public Object create(Class[] argTypes, Object[] args) {
        Constructor constructor = ClassUtil.getConstructor(this.enhancedClass, argTypes);
        return ConstructorUtil.newInstance(constructor, args);
    }

    private boolean isApplicableAspect(Method method) {
        int mod = method.getModifiers();
        return !Modifier.isFinal(mod) && !Modifier.isStatic(mod);
    }
}

