/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.framework.container.assembler;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ConstructorAssembler;
import org.seasar.framework.container.PropertyAssembler;

/**
 * 自動バンディング定義のプロパティ版です。
 * 
 * @author higa
 * 
 */
public class AutoBindingPropertyDef extends AbstractAutoBindingDef {

    /**
     * {@link AutoBindingPropertyDef}を作成します。
     * 
     * @param name
     */
    protected AutoBindingPropertyDef(String name) {
        super(name);
    }

    public ConstructorAssembler createConstructorAssembler(
            ComponentDef componentDef) {
        return AssemblerFactory
                .createDefaultConstructorConstructorAssembler(componentDef);
    }

    public PropertyAssembler createPropertyAssembler(ComponentDef componentDef) {
        return AssemblerFactory.createAutoPropertyAssembler(componentDef);
    }
}