/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.ejb.impl.EJB3InterceptorSupportInterType;
import org.seasar.framework.ejb.impl.InvocationContextImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3InterceptorSupportInterceptor
implements MethodInterceptor {
    protected Class<?> interceptorClass;
    protected Method interceptorMethod;
    protected Field interceptorField;

    public EJB3InterceptorSupportInterceptor(Class<?> interceptorClass, Method interceptorMethod) {
        this.interceptorClass = interceptorClass;
        this.interceptorMethod = interceptorMethod;
        this.interceptorMethod.setAccessible(true);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.interceptorField == null) {
            Class<?> targetClass = invocation.getThis().getClass();
            String fieldName = EJB3InterceptorSupportInterType.getFieldName(this.interceptorClass);
            this.interceptorField = ClassUtil.getDeclaredField(targetClass, (String)fieldName);
            this.interceptorField.setAccessible(true);
        }
        Object interceptor = FieldUtil.get((Field)this.interceptorField, (Object)invocation.getThis());
        InvocationContextImpl context = new InvocationContextImpl(invocation);
        return MethodUtil.invoke((Method)this.interceptorMethod, (Object)interceptor, (Object[])new Object[]{context});
    }
}

