/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.IterationCallback;
import org.seasar.extension.jdbc.IterationContext;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.handler.AbstractMapResultSetHandler;
import org.seasar.framework.convention.PersistenceConvention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapIterationResultSetHandler
extends AbstractMapResultSetHandler {
    protected int limit;
    protected IterationCallback callback;

    public MapIterationResultSetHandler(Class<? extends Map> mapClass, DbmsDialect dialect, PersistenceConvention peristenceConvention, String sql, int limit, IterationCallback callback) {
        super(mapClass, dialect, peristenceConvention, sql);
        this.limit = limit;
        this.callback = callback;
    }

    public Object handle(ResultSet rs) throws SQLException {
        PropertyType[] propertyTypes = this.createPropertyTypes(rs.getMetaData());
        IterationContext iterationContext = new IterationContext();
        Object result = null;
        for (int i = 0; (this.limit <= 0 || i < this.limit) && rs.next(); ++i) {
            Object entity = this.createRow(rs, propertyTypes);
            result = this.callback.iterate(entity, iterationContext);
            if (!iterationContext.isExit()) continue;
            return result;
        }
        return result;
    }
}

