/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters.util;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.AntFilterReader;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Parameterizable;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public final class ChainReaderHelper {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public Reader primaryReader;
    public int bufferSize = 8192;
    public Vector filterChains = new Vector();
    private Project project = null;
    static /* synthetic */ Class class$java$io$FilterReader;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Parameterizable;

    public void setPrimaryReader(Reader rdr) {
        this.primaryReader = rdr;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setFilterChains(Vector fchain) {
        this.filterChains = fchain;
    }

    public Reader getAssembledReader() throws BuildException {
        if (this.primaryReader == null) {
            throw new BuildException("primaryReader must not be null.");
        }
        Reader instream = this.primaryReader;
        int filterReadersCount = this.filterChains.size();
        Vector finalFilters = new Vector();
        for (int i = 0; i < filterReadersCount; ++i) {
            FilterChain filterchain = (FilterChain)this.filterChains.elementAt(i);
            Vector filterReaders = filterchain.getFilterReaders();
            int readerCount = filterReaders.size();
            for (int j = 0; j < readerCount; ++j) {
                finalFilters.addElement(filterReaders.elementAt(j));
            }
        }
        int filtersCount = finalFilters.size();
        if (filtersCount > 0) {
            for (int i = 0; i < filtersCount; ++i) {
                Object o = finalFilters.elementAt(i);
                if (o instanceof AntFilterReader) {
                    AntFilterReader filter = (AntFilterReader)finalFilters.elementAt(i);
                    String className = filter.getClassName();
                    Path classpath = filter.getClasspath();
                    Project pro = filter.getProject();
                    if (className == null) continue;
                    try {
                        int j;
                        Class<?> clazz = null;
                        if (classpath == null) {
                            clazz = Class.forName(className);
                        } else {
                            AntClassLoader al = pro.createClassLoader(classpath);
                            clazz = Class.forName(className, true, al);
                        }
                        if (clazz == null) continue;
                        if (!(class$java$io$FilterReader == null ? ChainReaderHelper.class$("java.io.FilterReader") : class$java$io$FilterReader).isAssignableFrom(clazz)) {
                            throw new BuildException(className + " does not extend java.io.FilterReader");
                        }
                        Constructor<?>[] constructors = clazz.getConstructors();
                        boolean consPresent = false;
                        for (j = 0; j < constructors.length; ++j) {
                            Class<?>[] types = constructors[j].getParameterTypes();
                            if (types.length != 1 || !types[0].isAssignableFrom(class$java$io$Reader == null ? ChainReaderHelper.class$("java.io.Reader") : class$java$io$Reader)) continue;
                            consPresent = true;
                            break;
                        }
                        if (!consPresent) {
                            throw new BuildException(className + " does not define a public constructor" + " that takes in a Reader as its " + "single argument.");
                        }
                        Reader[] rdr = new Reader[]{instream};
                        instream = (Reader)constructors[j].newInstance(rdr);
                        this.setProjectOnObject(instream);
                        if (!(class$org$apache$tools$ant$types$Parameterizable == null ? ChainReaderHelper.class$("org.apache.tools.ant.types.Parameterizable") : class$org$apache$tools$ant$types$Parameterizable).isAssignableFrom(clazz)) continue;
                        Parameter[] params = filter.getParams();
                        ((Parameterizable)((Object)instream)).setParameters(params);
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new BuildException(cnfe);
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw new BuildException(iae);
                    }
                    catch (InvocationTargetException ite) {
                        throw new BuildException(ite);
                    }
                }
                if (!(o instanceof ChainableReader)) continue;
                this.setProjectOnObject(o);
                instream = ((ChainableReader)o).chain(instream);
                this.setProjectOnObject(instream);
            }
        }
        return instream;
    }

    private void setProjectOnObject(Object obj) {
        if (this.project == null) {
            return;
        }
        if (obj instanceof BaseFilterReader) {
            ((BaseFilterReader)obj).setProject(this.project);
            return;
        }
        this.project.setProjectReference(obj);
    }

    public String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, this.bufferSize);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

