/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.Base64Util;

public class BlobType
extends AbstractSqlType {
    protected static byte[] EMPTY_BYTES = new byte[0];

    public BlobType() {
        this("blob");
    }

    public BlobType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 2004);
        } else if (value.length() == 0) {
            ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(EMPTY_BYTES), 0);
        } else {
            byte[] bytes = Base64Util.decode((String)value);
            ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Blob blob = resultSet.getBlob(index);
        if (blob == null) {
            return null;
        }
        long length = blob.length();
        if (length == 0L) {
            return Base64Util.encode((byte[])EMPTY_BYTES);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Base64Util.encode((byte[])blob.getBytes(1L, (int)length));
    }
}

