/*
 * Copyright 2004-2015 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package example.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * @author taedium
 * 
 */
@Entity
public class Employee {

    /** */
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="generator")
    @SequenceGenerator(name="generator")
    public Integer id;

    /** */
    @Column(nullable = false)
    public String firstName;

    /** */
    @Column(nullable = true, unique = false, precision = 3)
    public Integer age;

    /** */
    public Integer departmentId;

    /** */
    public Integer addressId;

    /** */
    @ManyToOne
    public Department department;

    /** */
    @OneToOne
    public Address address;
}
