/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import org.seasar.extension.jdbc.gen.desc.AttributeDesc;
import org.seasar.extension.jdbc.gen.desc.AttributeDescFactory;
import org.seasar.extension.jdbc.gen.desc.CompositeUniqueConstraintDesc;
import org.seasar.extension.jdbc.gen.desc.CompositeUniqueConstraintDescFactory;
import org.seasar.extension.jdbc.gen.desc.EntityDesc;
import org.seasar.extension.jdbc.gen.desc.EntityDescFactory;
import org.seasar.extension.jdbc.gen.meta.DbColumnMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMeta;
import org.seasar.extension.jdbc.gen.meta.DbUniqueKeyMeta;
import org.seasar.framework.convention.PersistenceConvention;

public class EntityDescFactoryImpl
implements EntityDescFactory {
    protected PersistenceConvention persistenceConvention;
    protected AttributeDescFactory attributeDescFactory;
    protected CompositeUniqueConstraintDescFactory compositeUniqueConstraintDescFactory;
    protected boolean schemaSpecified;

    public EntityDescFactoryImpl(PersistenceConvention persistenceConvention, AttributeDescFactory attributeDescFactory, CompositeUniqueConstraintDescFactory compositeUniqueConstraintDescFactory) {
        if (persistenceConvention == null) {
            throw new NullPointerException("persistenceConvention");
        }
        if (attributeDescFactory == null) {
            throw new NullPointerException("attributeDescFactory");
        }
        if (compositeUniqueConstraintDescFactory == null) {
            throw new NullPointerException("uniqueConstraintDescFactory");
        }
        this.persistenceConvention = persistenceConvention;
        this.attributeDescFactory = attributeDescFactory;
        this.compositeUniqueConstraintDescFactory = compositeUniqueConstraintDescFactory;
    }

    public EntityDesc getEntityDesc(DbTableMeta tableMeta) {
        EntityDesc entityDesc = new EntityDesc();
        this.doName(tableMeta, entityDesc);
        this.doTable(tableMeta, entityDesc);
        this.doAttributeDesc(tableMeta, entityDesc);
        this.doCompositeUniqueConstraintDesc(tableMeta, entityDesc);
        return entityDesc;
    }

    protected void doName(DbTableMeta tableMeta, EntityDesc entityDesc) {
        entityDesc.setName(this.persistenceConvention.fromTableNameToEntityName(tableMeta.getName()));
    }

    protected void doTable(DbTableMeta tableMeta, EntityDesc entityDesc) {
        entityDesc.setCatalogName(tableMeta.getCatalogName());
        entityDesc.setSchemaName(tableMeta.getSchemaName());
        entityDesc.setTableName(tableMeta.getName());
        entityDesc.setComment(tableMeta.getComment());
    }

    protected void doAttributeDesc(DbTableMeta tableMeta, EntityDesc entityDesc) {
        for (DbColumnMeta columnMeta : tableMeta.getColumnMetaList()) {
            AttributeDesc attributeDesc = this.attributeDescFactory.getAttributeDesc(tableMeta, columnMeta);
            entityDesc.addAttributeDesc(attributeDesc);
        }
    }

    protected void doCompositeUniqueConstraintDesc(DbTableMeta tableMeta, EntityDesc entityDesc) {
        for (DbUniqueKeyMeta uniqueKeyMeta : tableMeta.getUniqueKeyMetaList()) {
            CompositeUniqueConstraintDesc compositeUniqueConstraintDesc = this.compositeUniqueConstraintDescFactory.getCompositeUniqueConstraintDesc(uniqueKeyMeta);
            if (compositeUniqueConstraintDesc == null) continue;
            entityDesc.addCompositeUniqueConstraintDesc(compositeUniqueConstraintDesc);
        }
    }
}

