/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Select
extends Query {
    private TableFilter topTableFilter;
    private ObjectArray filters = new ObjectArray();
    private ObjectArray topFilters = new ObjectArray();
    private ObjectArray expressions;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ObjectArray orderList;
    private ObjectArray group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private boolean distinct;
    private HashMap currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isForUpdate;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private SortOrder sort;

    public Select(Session session) {
        super(session);
    }

    public void addTableFilter(TableFilter tableFilter, boolean bl) {
        this.filters.add(tableFilter);
        if (bl) {
            this.topFilters.add(tableFilter);
        }
    }

    public ObjectArray getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ObjectArray objectArray) {
        this.expressions = objectArray;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ObjectArray objectArray) {
        this.group = objectArray;
    }

    public HashMap getCurrentGroup() {
        return this.currentGroup;
    }

    public void setOrder(ObjectArray objectArray) {
        this.orderList = objectArray;
    }

    public void addCondition(Expression expression) {
        this.condition = this.condition == null ? expression : new ConditionAndOr(0, expression, this.condition);
    }

    private void queryGroupSorted(int n, LocalResult localResult) throws SQLException {
        int n2 = 0;
        this.setCurrentRowNumber(0);
        Object[] objectArray = null;
        while (this.topTableFilter.next()) {
            int n3;
            this.checkCancelled();
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n2;
            Object[] objectArray2 = new Value[this.groupIndex.length];
            for (n3 = 0; n3 < this.groupIndex.length; ++n3) {
                int n4 = this.groupIndex[n3];
                Expression expression = (Expression)this.expressions.get(n4);
                objectArray2[n3] = expression.getValue(this.session);
            }
            if (objectArray == null) {
                objectArray = objectArray2;
                this.currentGroup = new HashMap();
            } else if (!Arrays.equals(objectArray, objectArray2)) {
                this.addGroupSortedRow((Value[])objectArray, n, localResult);
                objectArray = objectArray2;
                this.currentGroup = new HashMap();
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
                Expression expression = (Expression)this.expressions.get(n3);
                expression.updateAggregate(this.session);
            }
        }
        if (objectArray != null) {
            this.addGroupSortedRow((Value[])objectArray, n, localResult);
        }
    }

    private void addGroupSortedRow(Value[] valueArray, int n, LocalResult localResult) throws SQLException {
        int n2;
        Object[] objectArray = new Value[n];
        for (n2 = 0; this.groupIndex != null && n2 < this.groupIndex.length; ++n2) {
            objectArray[this.groupIndex[n2]] = valueArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.groupByExpression != null && this.groupByExpression[n2]) continue;
            Expression expression = (Expression)this.expressions.get(n2);
            objectArray[n2] = expression.getValue(this.session);
        }
        if (this.havingIndex > 0) {
            Value value = objectArray[this.havingIndex];
            if (value == ValueNull.INSTANCE) {
                return;
            }
            if (!Boolean.TRUE.equals(value.getBoolean())) {
                return;
            }
        }
        if (n != this.distinctColumnCount) {
            Object[] objectArray2 = new Value[this.distinctColumnCount];
            ObjectUtils.arrayCopy(objectArray, objectArray2, this.distinctColumnCount);
            objectArray = objectArray2;
        }
        localResult.addRow((Value[])objectArray);
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ObjectArray objectArray = this.topTableFilter.getTable().getIndexes();
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            Index index = (Index)objectArray.get(i);
            if (index.getIndexType().getScan() || !this.isGroupSortedIndex(index)) continue;
            return index;
        }
        return null;
    }

    private boolean isGroupSortedIndex(Index index) {
        Column[] columnArray = index.getColumns();
        block0: for (int i = 0; i < this.expressions.size(); ++i) {
            if (!this.groupByExpression[i]) continue;
            Expression expression = (Expression)this.expressions.get(i);
            if (!(expression instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            for (int j = 0; j < columnArray.length; ++j) {
                if (columnArray[j].equals(expressionColumn.getColumn())) continue block0;
            }
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.groupByExpression.length; ++i) {
            if (!this.groupByExpression[i]) continue;
            ++n;
        }
        return n;
    }

    private void queryGroup(int n, LocalResult localResult) throws SQLException {
        Object object;
        Object object2;
        ValueHashMap valueHashMap = new ValueHashMap(this.session.getDatabase());
        int n2 = 0;
        this.setCurrentRowNumber(0);
        ValueArray valueArray = ValueArray.get(new Value[0]);
        while (this.topTableFilter.next()) {
            int n3;
            int n4;
            Object object3;
            this.checkCancelled();
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++n2;
            if (this.groupIndex == null) {
                object2 = valueArray;
            } else {
                object3 = new Value[this.groupIndex.length];
                for (n4 = 0; n4 < this.groupIndex.length; ++n4) {
                    n3 = this.groupIndex[n4];
                    object = (Expression)this.expressions.get(n3);
                    object3[n4] = ((Expression)object).getValue(this.session);
                }
                object2 = ValueArray.get(object3);
            }
            object3 = (HashMap)valueHashMap.get((Value)object2);
            if (object3 == null) {
                object3 = new HashMap();
                valueHashMap.put((Value)object2, object3);
            }
            this.currentGroup = object3;
            n4 = n;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.groupByExpression != null && this.groupByExpression[n3]) continue;
                object = (Expression)this.expressions.get(n3);
                ((Expression)object).updateAggregate(this.session);
            }
            if (this.sampleSize <= 0 || n2 < this.sampleSize) continue;
        }
        if (this.groupIndex == null && valueHashMap.size() == 0) {
            valueHashMap.put(valueArray, new HashMap());
        }
        object2 = valueHashMap.keys();
        for (int i = 0; i < ((ObjectArray)object2).size(); ++i) {
            Value value;
            int n5;
            ValueArray valueArray2 = (ValueArray)((ObjectArray)object2).get(i);
            this.currentGroup = (HashMap)valueHashMap.get(valueArray2);
            Value[] valueArray3 = valueArray2.getList();
            object = new Value[n];
            for (n5 = 0; this.groupIndex != null && n5 < this.groupIndex.length; ++n5) {
                object[this.groupIndex[n5]] = valueArray3[n5];
            }
            for (n5 = 0; n5 < n; ++n5) {
                if (this.groupByExpression != null && this.groupByExpression[n5]) continue;
                Expression expression = (Expression)this.expressions.get(n5);
                object[n5] = expression.getValue(this.session);
            }
            if (this.havingIndex > 0 && ((value = object[this.havingIndex]) == ValueNull.INSTANCE || !Boolean.TRUE.equals(value.getBoolean()))) continue;
            if (n != this.distinctColumnCount) {
                Object[] objectArray = new Value[this.distinctColumnCount];
                ObjectUtils.arrayCopy((Object[])object, objectArray, this.distinctColumnCount);
                object = objectArray;
            }
            localResult.addRow((Value[])object);
        }
    }

    private Index getSortIndex() throws SQLException {
        Object object;
        if (this.sort == null) {
            return null;
        }
        int[] nArray = this.sort.getIndexes();
        ObjectArray objectArray = new ObjectArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.expressions.size()) {
                throw Message.getInvalidValueException("" + (n + 1), "ORDER BY");
            }
            object = (Expression)this.expressions.get(n);
            if (((Expression)(object = ((Expression)object).getNonAliasExpression())).isConstant()) continue;
            if (!(object instanceof ExpressionColumn)) {
                return null;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)object;
            if (expressionColumn.getTableFilter() != this.topTableFilter) {
                return null;
            }
            objectArray.add(expressionColumn.getColumn());
        }
        Object[] objectArray2 = new Column[objectArray.size()];
        objectArray.toArray(objectArray2);
        int[] nArray2 = this.sort.getSortTypes();
        if (objectArray2.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        object = this.topTableFilter.getTable().getIndexes();
        for (int i = 0; object != null && i < ((ObjectArray)object).size(); ++i) {
            IndexColumn[] indexColumnArray;
            Index index = (Index)((ObjectArray)object).get(i);
            if (index.getCreateSQL() == null || index.getIndexType().getHash() || (indexColumnArray = index.getIndexColumns()).length < objectArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < objectArray2.length; ++j) {
                IndexColumn indexColumn = indexColumnArray[j];
                Object object2 = objectArray2[j];
                if (indexColumn.column != object2) {
                    bl = false;
                    break;
                }
                if (indexColumn.sortType == nArray2[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return index;
        }
        return null;
    }

    private void queryDistinct(LocalResult localResult, long l) throws SQLException {
        if (l != 0L && this.offset != null) {
            l += (long)this.offset.getValue(this.session).getInt();
        }
        int n = 0;
        this.setCurrentRowNumber(0);
        Index index = this.topTableFilter.getIndex();
        SearchRow searchRow = null;
        int n2 = index.getColumns()[0].getColumnId();
        do {
            this.checkCancelled();
            this.setCurrentRowNumber(n + 1);
            Cursor cursor = index.findNext(this.session, searchRow, null);
            if (!cursor.next()) break;
            SearchRow searchRow2 = cursor.getSearchRow();
            Value value = searchRow2.getValue(n2);
            if (searchRow == null) {
                searchRow = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            searchRow.setValue(n2, value);
            Value[] valueArray = new Value[]{value};
            localResult.addRow(valueArray);
        } while ((this.sort != null && !this.sortUsingIndex || l == 0L || (long)localResult.getRowCount() < l) && (this.sampleSize <= 0 || ++n < this.sampleSize));
    }

    private void queryFlat(int n, LocalResult localResult, long l) throws SQLException {
        if (l != 0L && this.offset != null) {
            l += (long)this.offset.getValue(this.session).getInt();
        }
        int n2 = 0;
        this.setCurrentRowNumber(0);
        while (this.topTableFilter.next()) {
            this.checkCancelled();
            this.setCurrentRowNumber(n2 + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                Expression expression = (Expression)this.expressions.get(i);
                valueArray[i] = expression.getValue(this.session);
            }
            localResult.addRow(valueArray);
            if ((this.sort != null && !this.sortUsingIndex || l == 0L || (long)localResult.getRowCount() < l) && (this.sampleSize <= 0 || ++n2 < this.sampleSize)) continue;
            break;
        }
    }

    private void queryQuick(int n, LocalResult localResult) throws SQLException {
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            valueArray[i] = expression.getValue(this.session);
        }
        localResult.addRow(valueArray);
    }

    public LocalResult queryMeta() throws SQLException {
        LocalResult localResult = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        localResult.done();
        return localResult;
    }

    protected LocalResult queryWithoutCache(int n) throws SQLException {
        int n2;
        int n3 = n;
        if (this.limit != null) {
            n2 = this.limit.getValue(this.session).getInt();
            n3 = n3 == 0 ? n2 : Math.min(n2, n3);
        }
        n2 = this.expressions.size();
        LocalResult localResult = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        if (!this.sortUsingIndex) {
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct && !this.isDistinctQuery) {
            localResult.setDistinct();
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        this.topTableFilter.lock(this.session, this.isForUpdate, this.isForUpdate);
        if (this.isQuickAggregateQuery) {
            this.queryQuick(n2, localResult);
        } else if (this.isGroupQuery) {
            if (this.isGroupSortedQuery) {
                this.queryGroupSorted(n2, localResult);
            } else {
                this.queryGroup(n2, localResult);
            }
        } else if (this.isDistinctQuery) {
            this.queryDistinct(localResult, n3);
        } else {
            this.queryFlat(n2, localResult, n3);
        }
        if (this.offset != null) {
            localResult.setOffset(this.offset.getValue(this.session).getInt());
        }
        if (n3 != 0) {
            localResult.setLimit(n3);
        }
        localResult.done();
        return localResult;
    }

    private void expandColumnList() throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Object object;
            Object object2;
            int n;
            Expression expression = (Expression)this.expressions.get(i);
            if (!expression.isWildcard()) continue;
            String string = expression.getSchemaName();
            String string2 = expression.getTableAlias();
            if (string2 == null) {
                int n2 = i;
                this.expressions.remove(i);
                for (n = 0; n < this.filters.size(); ++n) {
                    object2 = (TableFilter)this.filters.get(n);
                    object = new Wildcard(((TableFilter)object2).getTable().getSchema().getName(), ((TableFilter)object2).getTableAlias());
                    this.expressions.add(i++, object);
                }
                i = n2 - 1;
                continue;
            }
            Object object3 = null;
            for (n = 0; n < this.filters.size(); ++n) {
                object2 = (TableFilter)this.filters.get(n);
                if (!string2.equals(((TableFilter)object2).getTableAlias()) || string != null && !string.equals(((TableFilter)object2).getSchemaName())) continue;
                object3 = object2;
                break;
            }
            if (object3 == null) {
                throw Message.getSQLException(42102, string2);
            }
            Table table = ((TableFilter)object3).getTable();
            object2 = ((TableFilter)object3).getTableAlias();
            this.expressions.remove(i);
            object = table.getColumns();
            for (int j = 0; j < ((Column[])object).length; ++j) {
                Column column = object[j];
                ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), null, (String)object2, column.getName());
                this.expressions.add(i++, expressionColumn);
            }
            --i;
        }
    }

    public void init() throws SQLException {
        String string;
        Object object;
        int n;
        ObjectArray objectArray;
        if (SysProperties.CHECK && this.checkInit) {
            throw Message.getInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null || this.group != null) {
            objectArray = new ObjectArray();
            for (n = 0; n < this.expressions.size(); ++n) {
                object = (Expression)this.expressions.get(n);
                object = ((Expression)object).getNonAliasExpression();
                string = ((Expression)object).getSQL();
                objectArray.add(string);
            }
        } else {
            objectArray = null;
        }
        if (this.orderList != null) {
            this.initOrder(this.expressions, objectArray, this.orderList, this.visibleColumnCount, this.distinct);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.group != null) {
            this.groupIndex = new int[this.group.size()];
            for (n = 0; n < this.group.size(); ++n) {
                int n2;
                object = (Expression)this.group.get(n);
                string = ((Expression)object).getSQL();
                int n3 = -1;
                for (n2 = 0; n2 < objectArray.size(); ++n2) {
                    String string2 = (String)objectArray.get(n2);
                    if (!string2.equals(string)) continue;
                    n3 = n2;
                    break;
                }
                if (n3 < 0) {
                    this.groupIndex[n] = n2 = this.expressions.size();
                    this.expressions.add(object);
                    continue;
                }
                this.groupIndex[n] = n3;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (n = 0; n < this.groupIndex.length; ++n) {
                this.groupByExpression[this.groupIndex[n]] = true;
            }
            this.group = null;
        }
        for (n = 0; n < this.filters.size(); ++n) {
            object = (TableFilter)this.filters.get(n);
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression expression = (Expression)this.expressions.get(i);
                expression.mapColumns((ColumnResolver)object, 0);
            }
            if (this.condition == null) continue;
            this.condition.mapColumns((ColumnResolver)object, 0);
        }
        this.checkInit = true;
    }

    public void prepare() throws SQLException {
        Object object;
        int n;
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            throw Message.getInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        for (n = 0; n < this.expressions.size(); ++n) {
            object = (Expression)this.expressions.get(n);
            this.expressions.set(n, ((Expression)object).optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            if (SysProperties.OPTIMIZE_IN_JOIN) {
                this.condition = this.condition.optimizeInJoin(this.session, this);
            }
            for (n = 0; n < this.filters.size(); ++n) {
                object = (TableFilter)this.filters.get(n);
                this.condition.createIndexConditions(this.session, (TableFilter)object);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1 && this.condition == null) {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.get(1);
            expressionVisitor.setTable(((TableFilter)this.filters.get(0)).getTable());
            this.isQuickAggregateQuery = this.isEverything(expressionVisitor);
        }
        this.cost = this.preparePlan();
        if (SysProperties.OPTIMIZE_DISTINCT && this.distinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expression = (Expression)this.expressions.get(0);
            if ((expression = expression.getNonAliasExpression()) instanceof ExpressionColumn) {
                object = ((ExpressionColumn)expression).getColumn();
                int n2 = ((Column)object).getSelectivity();
                Index index = this.topTableFilter.getTable().getIndexForColumn((Column)object, true);
                if (index != null && n2 != 50 && n2 < 20) {
                    IndexType indexType;
                    boolean bl = index.getIndexColumns()[0].sortType == 0;
                    Index index2 = this.topTableFilter.getIndex();
                    if (!(!index.canFindNext() || !bl || index2 != null && !index2.getIndexType().getScan() && index != index2 || (indexType = index.getIndexType()).getHash() || indexType.getUnique() && index.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex(index);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            Index index = this.getSortIndex();
            object = this.topTableFilter.getIndex();
            if (index != null && (object.getIndexType().getScan() || object == index)) {
                this.topTableFilter.setIndex(index);
                if (!this.distinct || this.isDistinctQuery) {
                    this.sortUsingIndex = true;
                }
            }
        }
        if (SysProperties.OPTIMIZE_GROUP_SORTED && !this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            Index index = this.getGroupSortedIndex();
            object = this.topTableFilter.getIndex();
            if (index != null && (object.getIndexType().getScan() || object == index)) {
                this.topTableFilter.setIndex(index);
                this.isGroupSortedQuery = true;
            }
        }
        this.isPrepared = true;
    }

    public double getCost() {
        return this.cost;
    }

    public HashSet getTables() {
        HashSet<Table> hashSet = new HashSet<Table>();
        for (int i = 0; i < this.filters.size(); ++i) {
            TableFilter tableFilter = (TableFilter)this.filters.get(i);
            hashSet.add(tableFilter.getTable());
        }
        return hashSet;
    }

    private double preparePlan() throws SQLException {
        Object[] objectArray = new TableFilter[this.topFilters.size()];
        this.topFilters.toArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            ((TableFilter)objectArray[i]).setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer((TableFilter[])objectArray, this.condition, this.session);
        optimizer.optimize();
        this.topTableFilter = optimizer.getTopFilter();
        double d = optimizer.getCost();
        for (TableFilter tableFilter = this.topTableFilter; tableFilter != null; tableFilter = tableFilter.getJoin()) {
            Expression expression;
            tableFilter.setEvaluatable(tableFilter, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(tableFilter, true);
            }
            if ((expression = tableFilter.getJoinCondition()) != null && !expression.isEverything(3)) {
                if (tableFilter.isJoinOuter()) {
                    throw Message.getSQLException(90136, expression.getSQL());
                }
                tableFilter.removeJoinCondition();
                expression = expression.optimize(this.session);
                this.addCondition(expression);
            }
            if ((expression = tableFilter.getFilterCondition()) != null && !expression.isEverything(3)) {
                tableFilter.removeFilterCondition();
                this.addCondition(expression);
            }
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression expression2 = (Expression)this.expressions.get(i);
                expression2.setEvaluatable(tableFilter, true);
            }
        }
        this.topTableFilter.prepare();
        return d;
    }

    public String getPlanSQL() {
        if (this.topTableFilter == null) {
            return this.sqlStatement;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Expression[this.expressions.size()];
        this.expressions.toArray(objectArray);
        stringBuffer.append("SELECT ");
        if (this.distinct) {
            stringBuffer.append("DISTINCT ");
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            Object object = objectArray[i];
            stringBuffer.append(((Expression)object).getSQL());
        }
        stringBuffer.append("\nFROM ");
        TableFilter tableFilter = this.topTableFilter;
        boolean bl = false;
        int n = 0;
        do {
            if (n > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(tableFilter.getPlanSQL(bl));
            ++n;
            bl = true;
        } while ((tableFilter = tableFilter.getJoin()) != null);
        if (this.condition != null) {
            stringBuffer.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            stringBuffer.append("\nGROUP BY ");
            for (int i = 0; i < this.groupIndex.length; ++i) {
                Object object = objectArray[this.groupIndex[i]];
                object = ((Expression)object).getNonAliasExpression();
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(StringUtils.unEnclose(((Expression)object).getSQL()));
            }
        }
        if (this.having != null) {
            Expression expression = this.having;
            stringBuffer.append("\nHAVING " + StringUtils.unEnclose(expression.getSQL()));
        } else if (this.havingIndex >= 0) {
            Object object = objectArray[this.havingIndex];
            stringBuffer.append("\nHAVING " + StringUtils.unEnclose(((Expression)object).getSQL()));
        }
        if (this.sort != null) {
            stringBuffer.append("\nORDER BY ");
            stringBuffer.append(this.sort.getSQL((Expression[])objectArray, this.visibleColumnCount));
        }
        if (this.limit != null) {
            stringBuffer.append("\nLIMIT ");
            stringBuffer.append(StringUtils.unEnclose(this.limit.getSQL()));
            if (this.offset != null) {
                stringBuffer.append(" OFFSET ");
                stringBuffer.append(StringUtils.unEnclose(this.offset.getSQL()));
            }
        }
        if (this.isForUpdate) {
            stringBuffer.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            stringBuffer.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            stringBuffer.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            stringBuffer.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            stringBuffer.append("\n/* group sorted */");
        }
        return stringBuffer.toString();
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    public ObjectArray getExpressions() {
        return this.expressions;
    }

    public void setForUpdate(boolean bl) {
        this.isForUpdate = bl;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            expression.mapColumns(columnResolver, n);
        }
        if (this.condition != null) {
            this.condition.mapColumns(columnResolver, n);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            expression.setEvaluatable(tableFilter, bl);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, bl);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    public void addGlobalCondition(Parameter parameter, int n, int n2) throws SQLException {
        this.addParameter(parameter);
        Expression expression = (Expression)this.expressions.get(n);
        expression = expression.getNonAliasExpression();
        Expression expression2 = new Comparison(this.session, n2, expression, parameter);
        expression2 = ((Expression)expression2).optimize(this.session);
        boolean bl = true;
        if (this.isGroupQuery) {
            bl = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.havingIndex >= 0) {
                    this.having = (Expression)this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? expression2 : new ConditionAndOr(0, this.having, expression2);
            }
        }
        if (bl) {
            this.condition = this.condition == null ? expression2 : new ConditionAndOr(0, this.condition, expression2);
        }
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            expression.updateAggregate(session);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(session);
        }
        if (this.having != null) {
            this.having.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        int n;
        switch (expressionVisitor.getType()) {
            case 4: {
                TableFilter tableFilter;
                for (n = 0; n < this.filters.size(); ++n) {
                    tableFilter = (TableFilter)this.filters.get(n);
                    long l = tableFilter.getTable().getMaxDataModificationId();
                    expressionVisitor.addDataModificationId(l);
                }
                break;
            }
            case 3: {
                if (SysProperties.OPTIMIZE_EVALUATABLE_SUBQUERIES) break;
                return false;
            }
            case 7: {
                TableFilter tableFilter;
                for (n = 0; n < this.filters.size(); ++n) {
                    tableFilter = (TableFilter)this.filters.get(n);
                    Table table = tableFilter.getTable();
                    expressionVisitor.addDependency(table);
                    table.addDependencies(expressionVisitor.getDependencies());
                }
                break;
            }
        }
        expressionVisitor.incrementQueryLevel(1);
        n = 1;
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            if (expression.isEverything(expressionVisitor)) continue;
            n = 0;
            break;
        }
        if (n != 0 && this.condition != null && !this.condition.isEverything(expressionVisitor)) {
            n = 0;
        }
        if (n != 0 && this.having != null && !this.having.isEverything(expressionVisitor)) {
            n = 0;
        }
        expressionVisitor.incrementQueryLevel(-1);
        return n != 0;
    }

    public boolean isReadOnly() {
        return this.isEverything(5);
    }

    public String getFirstColumnAlias(Session session) {
        if (SysProperties.CHECK && this.visibleColumnCount > 1) {
            throw Message.getInternalError("" + this.visibleColumnCount);
        }
        Expression expression = (Expression)this.expressions.get(0);
        if (expression instanceof Alias) {
            return expression.getAlias();
        }
        expression = new Alias(expression, session.getNextTempViewName() + "_X");
        this.expressions.set(0, expression);
        return expression.getAlias();
    }
}

