/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.h2.tools.SimpleRowSource;

public class SimpleResultSet
implements ResultSet,
ResultSetMetaData {
    private ArrayList rows;
    private Object[] currentRow;
    private int rowId = -1;
    private boolean wasNull;
    private SimpleRowSource source;
    private ArrayList columns = new ArrayList();

    public SimpleResultSet() {
        this.rows = new ArrayList();
    }

    public SimpleResultSet(SimpleRowSource simpleRowSource) {
        this.source = simpleRowSource;
    }

    public void addColumn(String string, int n, int n2, int n3) throws SQLException {
        if (this.rows != null && this.rows.size() > 0) {
            throw new SQLException("Cannot add a column after adding rows", "21S02");
        }
        if (string == null) {
            string = "C" + (this.columns.size() + 1);
        }
        Column column = new Column();
        column.name = string;
        column.sqlType = n;
        column.precision = n2;
        column.scale = n3;
        this.columns.add(column);
    }

    public void addRow(Object[] objectArray) throws SQLException {
        if (this.rows == null) {
            throw new SQLException("Cannot add a row when using RowSource", "21S02");
        }
        this.rows.add(objectArray);
    }

    public int getConcurrency() {
        return 1007;
    }

    public int getFetchDirection() {
        return 1000;
    }

    public int getFetchSize() {
        return 0;
    }

    public int getRow() {
        return this.rowId + 1;
    }

    public int getType() {
        return 1003;
    }

    public void close() {
        this.currentRow = null;
        this.rows = null;
        this.columns = null;
        this.rowId = -1;
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    public boolean next() throws SQLException {
        if (this.source != null) {
            ++this.rowId;
            this.currentRow = this.source.readRow();
            if (this.currentRow != null) {
                return true;
            }
        } else if (this.rows != null && this.rowId < this.rows.size()) {
            ++this.rowId;
            if (this.rowId < this.rows.size()) {
                this.currentRow = (Object[])this.rows.get(this.rowId);
                return true;
            }
        }
        this.close();
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.rowId = -1;
        if (this.source != null) {
            this.source.reset();
        }
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Number)) {
            object = Byte.decode(object.toString());
        }
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Number)) {
            return Double.parseDouble(object.toString());
        }
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Number)) {
            return Float.parseFloat(object.toString());
        }
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public int getInt(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Number)) {
            object = Integer.decode(object.toString());
        }
        return object == null ? 0 : ((Number)object).intValue();
    }

    public long getLong(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Number)) {
            object = Long.decode(object.toString());
        }
        return object == null ? 0L : ((Number)object).longValue();
    }

    public short getShort(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Number)) {
            object = Short.decode(object.toString());
        }
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof Boolean)) {
            object = Boolean.valueOf(object.toString());
        }
        return object == null ? false : (Boolean)object;
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.get(n);
    }

    public Object getObject(int n) throws SQLException {
        return this.get(n);
    }

    public String getString(int n) throws SQLException {
        Object object = this.get(n);
        return object == null ? null : object.toString();
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        for (int i = 0; string != null && this.columns != null && i < this.columns.size(); ++i) {
            if (!string.equalsIgnoreCase(this.getColumn((int)i).name)) continue;
            return i + 1;
        }
        throw new SQLException("Column not found: " + string, "42S22");
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.get(n);
        if (object != null && !(object instanceof BigDecimal)) {
            object = new BigDecimal(object.toString());
        }
        return (BigDecimal)object;
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.get(n);
    }

    public ResultSetMetaData getMetaData() {
        return this;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public Statement getStatement() {
        return null;
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.get(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.get(n);
    }

    public Array getArray(int n) throws SQLException {
        return new SimpleArray((Object[])this.get(n));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnDisplaySize(int n) {
        return 15;
    }

    public int getColumnType(int n) throws SQLException {
        return this.getColumn((int)(n - 1)).sqlType;
    }

    public int getPrecision(int n) throws SQLException {
        return this.getColumn((int)(n - 1)).precision;
    }

    public int getScale(int n) throws SQLException {
        return this.getColumn((int)(n - 1)).scale;
    }

    public int isNullable(int n) {
        return 2;
    }

    public boolean isAutoIncrement(int n) {
        return false;
    }

    public boolean isCaseSensitive(int n) {
        return true;
    }

    public boolean isCurrency(int n) {
        return false;
    }

    public boolean isDefinitelyWritable(int n) {
        return false;
    }

    public boolean isReadOnly(int n) {
        return true;
    }

    public boolean isSearchable(int n) {
        return true;
    }

    public boolean isSigned(int n) {
        return true;
    }

    public boolean isWritable(int n) {
        return false;
    }

    public String getCatalogName(int n) {
        return null;
    }

    public String getColumnClassName(int n) {
        return null;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumn((int)(n - 1)).name;
    }

    public String getColumnName(int n) throws SQLException {
        return this.getColumnLabel(n);
    }

    public String getColumnTypeName(int n) {
        return null;
    }

    public String getSchemaName(int n) {
        return null;
    }

    public String getTableName(int n) {
        return null;
    }

    public void clearWarnings() {
    }

    public void afterLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateNull(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void deleteRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void insertRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void moveToInsertRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void refreshRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean first() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean isAfterLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean isBeforeFirst() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean isFirst() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean isLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean last() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean previous() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean rowDeleted() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean rowInserted() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean rowUpdated() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void setFetchDirection(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void setFetchSize(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateNull(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean absolute(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public boolean relative(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateLong(int n, long l) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateShort(int n, short s) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public InputStream getAsciiStream(int n) {
        return null;
    }

    public InputStream getBinaryStream(int n) {
        return null;
    }

    public InputStream getUnicodeStream(int n) {
        return null;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public String getCursorName() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateString(int n, String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateInt(String string, int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateLong(String string, long l) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateShort(String string, short s) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public URL getURL(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Blob getBlob(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Clob getClob(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Ref getRef(int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateString(String string, String string2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public URL getURL(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Blob getBlob(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Clob getClob(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Ref getRef(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    static SQLException getUnsupportedException() {
        return new SQLException("Feature not supported", "HYC00");
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (n < 0 || n >= this.columns.size()) {
            throw new SQLException("Invalid column index " + (n + 1), "90009");
        }
    }

    private Object get(int n) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("No data is available", "02000");
        }
        this.checkColumnIndex(--n);
        Object object = n < this.currentRow.length ? this.currentRow[n] : null;
        this.wasNull = object == null;
        return object;
    }

    private Column getColumn(int n) throws SQLException {
        this.checkColumnIndex(n);
        return (Column)this.columns.get(n);
    }

    public int getHoldability() {
        return 1;
    }

    public boolean isClosed() {
        return this.rows == null;
    }

    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    private static class SimpleArray
    implements Array {
        private Object[] value;

        SimpleArray(Object[] objectArray) {
            this.value = objectArray;
        }

        public Object getArray() {
            return this.value;
        }

        public Object getArray(Map map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public Object getArray(long l, int n) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public Object getArray(long l, int n, Map map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public int getBaseType() {
            return 0;
        }

        public String getBaseTypeName() {
            return "NULL";
        }

        public ResultSet getResultSet() throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public ResultSet getResultSet(Map map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public ResultSet getResultSet(long l, int n) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        public void free() {
        }
    }

    static class Column {
        String name;
        int sqlType;
        int precision;
        int scale;

        Column() {
        }
    }
}

