/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import java.util.ArrayList;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.gen.generator.GenerationContext;
import org.seasar.extension.jdbc.gen.generator.Generator;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyNullRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.NamesAggregateModel;
import org.seasar.extension.jdbc.gen.model.NamesAggregateModelFactory;
import org.seasar.extension.jdbc.gen.model.NamesModel;
import org.seasar.extension.jdbc.gen.model.NamesModelFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

public class GenerateNamesCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(GenerateNamesCommand.class);
    protected File classpathDir;
    protected String rootPackageName = "";
    protected String entityPackageName = "entity";
    protected String entityClassNamePattern = ".*";
    protected String ignoreEntityClassNamePattern = "";
    protected String namesPackageName = "entity";
    protected String namesClassNameSuffix = "Names";
    protected String namesTemplateFileName = "java/names.ftl";
    protected String templateFileEncoding = "UTF-8";
    protected File templateFilePrimaryDir = null;
    protected File javaFileDestDir = new File(new File("src", "main"), "java");
    protected String javaFileEncoding = "UTF-8";
    protected boolean overwrite = true;
    protected boolean generateNamesAggregateClass = true;
    protected String namesAggregateShortClassName = "Names";
    protected String namesAggregateTemplateFileName = "java/names-aggregate.ftl";
    protected EntityMetaReader entityMetaReader;
    protected NamesModelFactory namesModelFactory;
    protected NamesAggregateModelFactory namesAggregateModelFactory;
    protected Generator generator;

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public void setClasspathDir(File classpathDir) {
        this.classpathDir = classpathDir;
    }

    public String getNamesClassNameSuffix() {
        return this.namesClassNameSuffix;
    }

    public void setNamesClassNameSuffix(String namesClassNameSuffix) {
        this.namesClassNameSuffix = namesClassNameSuffix;
    }

    public String getNamesPackageName() {
        return this.namesPackageName;
    }

    public void setNamesPackageName(String namesPackageName) {
        this.namesPackageName = namesPackageName;
    }

    public String getNamesTemplateFileName() {
        return this.namesTemplateFileName;
    }

    public void setNamesTemplateFileName(String namesTemplateFileName) {
        this.namesTemplateFileName = namesTemplateFileName;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public String getEntityClassNamePattern() {
        return this.entityClassNamePattern;
    }

    public void setEntityClassNamePattern(String entityClassNamePattern) {
        this.entityClassNamePattern = entityClassNamePattern;
    }

    public String getIgnoreEntityClassNamePattern() {
        return this.ignoreEntityClassNamePattern;
    }

    public void setIgnoreEntityClassNamePattern(String ignoreEntityClassNamePattern) {
        this.ignoreEntityClassNamePattern = ignoreEntityClassNamePattern;
    }

    public File getJavaFileDestDir() {
        return this.javaFileDestDir;
    }

    public void setJavaFileDestDir(File javaFileDestDir) {
        this.javaFileDestDir = javaFileDestDir;
    }

    public String getJavaFileEncoding() {
        return this.javaFileEncoding;
    }

    public void setJavaFileEncoding(String javaFileEncoding) {
        this.javaFileEncoding = javaFileEncoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public String getTemplateFileEncoding() {
        return this.templateFileEncoding;
    }

    public void setTemplateFileEncoding(String templateFileEncoding) {
        this.templateFileEncoding = templateFileEncoding;
    }

    public File getTemplateFilePrimaryDir() {
        return this.templateFilePrimaryDir;
    }

    public void setTemplateFilePrimaryDir(File templateFilePrimaryDir) {
        this.templateFilePrimaryDir = templateFilePrimaryDir;
    }

    public boolean isGenerateNamesAggregateClass() {
        return this.generateNamesAggregateClass;
    }

    public void setGenerateNamesAggregateClass(boolean generateNamesAggregateClass) {
        this.generateNamesAggregateClass = generateNamesAggregateClass;
    }

    public String getNamesAggregateShortClassName() {
        return this.namesAggregateShortClassName;
    }

    public void setNamesAggregateShortClassName(String namesAggregateShortClassName) {
        this.namesAggregateShortClassName = namesAggregateShortClassName;
    }

    public String getNamesAggregateTemplateFileName() {
        return this.namesAggregateTemplateFileName;
    }

    public void setNamesAggregateTemplateFileName(String namesAggregateTemplateFileName) {
        this.namesAggregateTemplateFileName = namesAggregateTemplateFileName;
    }

    protected void doValidate() {
        if (this.classpathDir == null) {
            throw new RequiredPropertyNullRuntimeException("classpathDir");
        }
    }

    protected void doInit() {
        this.entityMetaReader = this.createEntityMetaReader();
        this.namesModelFactory = this.createNamesModelFactory();
        this.namesAggregateModelFactory = this.createNamesAggregateModelFactory();
        this.generator = this.createGenerator();
    }

    protected void doExecute() {
        ArrayList<NamesModel> namesModelList = new ArrayList<NamesModel>();
        for (EntityMeta entityMeta : this.entityMetaReader.read()) {
            NamesModel namesModel = this.namesModelFactory.getNamesModel(entityMeta);
            this.generateNames(namesModel);
            if (!this.generateNamesAggregateClass) continue;
            namesModelList.add(namesModel);
        }
        if (namesModelList.size() > 0) {
            NamesAggregateModel namesAggregateModel = this.namesAggregateModelFactory.getNamesAggregateModel(namesModelList);
            this.generateNamesAggregate(namesAggregateModel);
        }
    }

    protected void doDestroy() {
    }

    protected void generateNames(NamesModel namesModel) {
        GenerationContext context = this.createGenerationContext(namesModel, this.namesTemplateFileName);
        this.generator.generate(context);
    }

    protected void generateNamesAggregate(NamesAggregateModel namesAggregateModel) {
        GenerationContext context = this.createGenerationContext(namesAggregateModel, this.namesAggregateTemplateFileName);
        this.generator.generate(context);
    }

    protected GenerationContext createGenerationContext(ClassModel model, String templateName) {
        File file = FileUtil.createJavaFile(this.javaFileDestDir, model.getPackageName(), model.getShortClassName());
        return this.factory.createGenerationContext(this, model, file, templateName, this.javaFileEncoding, this.overwrite);
    }

    protected EntityMetaReader createEntityMetaReader() {
        return this.factory.createEntityMetaReader(this, this.classpathDir, ClassUtil.concatName((String)this.rootPackageName, (String)this.entityPackageName), this.jdbcManager.getEntityMetaFactory(), this.entityClassNamePattern, this.ignoreEntityClassNamePattern, false, null, null);
    }

    protected NamesModelFactory createNamesModelFactory() {
        return this.factory.createNamesModelFactory(this, ClassUtil.concatName((String)this.rootPackageName, (String)this.namesPackageName), this.namesClassNameSuffix);
    }

    protected NamesAggregateModelFactory createNamesAggregateModelFactory() {
        return this.factory.createNamesAggregateModelFactory(this, ClassUtil.concatName((String)this.rootPackageName, (String)this.namesPackageName), this.namesAggregateShortClassName);
    }

    protected Generator createGenerator() {
        return this.factory.createGenerator(this, this.templateFileEncoding, this.templateFilePrimaryDir);
    }

    protected Logger getLogger() {
        return logger;
    }
}

