/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.gen.desc.ColumnDesc;
import org.seasar.extension.jdbc.gen.desc.ForeignKeyDesc;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDesc;
import org.seasar.extension.jdbc.gen.desc.SequenceDesc;
import org.seasar.extension.jdbc.gen.desc.UniqueKeyDesc;
import org.seasar.extension.jdbc.gen.exception.ColumnDescNotFoundRuntimeException;
import org.seasar.framework.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDesc {
    protected final Key key = new Key();
    protected String catalogName;
    protected String schemaName;
    protected String name;
    protected String canonicalName;
    protected String comment;
    protected List<ColumnDesc> columnDescList = new ArrayList<ColumnDesc>();
    protected Map<String, ColumnDesc> columnDescMap = new CaseInsensitiveMap();
    protected PrimaryKeyDesc primaryKeyDesc;
    protected List<ForeignKeyDesc> foreignKeyDescList = new ArrayList<ForeignKeyDesc>();
    protected List<UniqueKeyDesc> uniqueKeyDescList = new ArrayList<UniqueKeyDesc>();
    protected List<SequenceDesc> sequenceDesclist = new ArrayList<SequenceDesc>();
    protected List<TableDesc> idTableDescList = new ArrayList<TableDesc>();

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        StringBuilder buf = new StringBuilder();
        if (this.catalogName != null) {
            buf.append(this.catalogName).append(".");
        }
        if (this.schemaName != null) {
            buf.append(this.schemaName).append(".");
        }
        return buf.append(this.name).toString();
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        this.key.setCanonicalName(canonicalName);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnDesc> getColumnDescList() {
        return Collections.unmodifiableList(this.columnDescList);
    }

    public void addColumnDesc(ColumnDesc columnDesc) {
        if (!this.columnDescList.contains(columnDesc)) {
            this.columnDescList.add(columnDesc);
            this.columnDescMap.put(columnDesc.getName(), columnDesc);
        }
    }

    public PrimaryKeyDesc getPrimaryKeyDesc() {
        return this.primaryKeyDesc;
    }

    public void setPrimaryKeyDesc(PrimaryKeyDesc primaryKeyDesc) {
        this.primaryKeyDesc = primaryKeyDesc;
    }

    public List<ForeignKeyDesc> getForeignKeyDescList() {
        return Collections.unmodifiableList(this.foreignKeyDescList);
    }

    public void addForeignKeyDesc(ForeignKeyDesc foreignKeyDesc) {
        if (!this.foreignKeyDescList.contains(foreignKeyDesc)) {
            this.foreignKeyDescList.add(foreignKeyDesc);
        }
    }

    public List<UniqueKeyDesc> getUniqueKeyDescList() {
        return Collections.unmodifiableList(this.uniqueKeyDescList);
    }

    public void addUniqueKeyDesc(UniqueKeyDesc uniqueKeyDesc) {
        if (!this.uniqueKeyDescList.contains(uniqueKeyDesc)) {
            this.uniqueKeyDescList.add(uniqueKeyDesc);
        }
    }

    public List<SequenceDesc> getSequenceDescList() {
        return Collections.unmodifiableList(this.sequenceDesclist);
    }

    public void addSequenceDesc(SequenceDesc sequenceDesc) {
        if (!this.sequenceDesclist.contains(sequenceDesc)) {
            this.sequenceDesclist.add(sequenceDesc);
        }
    }

    public List<TableDesc> getIdTableDescList() {
        return Collections.unmodifiableList(this.idTableDescList);
    }

    public void addIdTableDesc(TableDesc idTableDesc) {
        this.idTableDescList.add(idTableDesc);
    }

    public ColumnDesc getColumnDesc(String columnName) throws ColumnDescNotFoundRuntimeException {
        if (this.columnDescMap.containsKey(columnName)) {
            return this.columnDescMap.get(columnName);
        }
        throw new ColumnDescNotFoundRuntimeException(columnName, this.getFullName());
    }

    public boolean hasIdentityColumn() {
        for (ColumnDesc columnDesc : this.columnDescList) {
            if (!columnDesc.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableDesc other = (TableDesc)obj;
        return this.key.equals(other.key);
    }

    protected static class Key {
        protected String canonicalName;

        protected Key() {
        }

        public void setCanonicalName(String canonicalName) {
            this.canonicalName = canonicalName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.canonicalName == null ? 0 : this.canonicalName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.canonicalName == null ? other.canonicalName != null : !this.canonicalName.equals(other.canonicalName));
        }
    }
}

