/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.util.LittleEndian;

public class FuncPtg
extends AbstractFunctionPtg {
    public static final byte sid = 33;
    public static final int SIZE = 3;
    private int numParams = 0;

    private FuncPtg() {
    }

    public FuncPtg(RecordInputStream in) {
        this.field_2_fnc_index = in.readShort();
        try {
            this.numParams = (Integer)functionData[this.field_2_fnc_index][2];
        }
        catch (NullPointerException npe) {
            this.numParams = 0;
        }
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = (byte)(33 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_2_fnc_index);
    }

    public int getNumberOfOperands() {
        return this.numParams;
    }

    public Object clone() {
        FuncPtg ptg = new FuncPtg();
        ptg.field_2_fnc_index = this.field_2_fnc_index;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public int getSize() {
        return 3;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<FunctionPtg>").append("\n").append("   numArgs(internal)=").append(this.numParams).append("\n").append("      name         =").append(this.lookupName(this.field_2_fnc_index)).append("\n").append("   field_2_fnc_index=").append(this.field_2_fnc_index).append("\n").append("</FunctionPtg>");
        return buffer.toString();
    }
}

