/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.Service;
import org.apache.fop.apps.StreamRenderer;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.ConfigurationReader;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.mif.MIFRenderer;
import org.apache.fop.render.pcl.PCLRenderer;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.ps.PSRenderer;
import org.apache.fop.render.svg.SVGRenderer;
import org.apache.fop.render.txt.TXTRenderer;
import org.apache.fop.render.xml.XMLRenderer;
import org.apache.fop.tools.DocumentInputSource;
import org.apache.fop.tools.DocumentReader;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Driver {
    public static final int RENDER_PDF = 1;
    public static final int RENDER_AWT = 2;
    public static final int RENDER_MIF = 3;
    public static final int RENDER_XML = 4;
    public static final int RENDER_PRINT = 5;
    public static final int RENDER_PCL = 6;
    public static final int RENDER_PS = 7;
    public static final int RENDER_TXT = 8;
    public static final int RENDER_SVG = 9;
    private FOTreeBuilder _treeBuilder = new FOTreeBuilder();
    private Renderer _renderer;
    private InputSource _source;
    private OutputStream _stream = null;
    private XMLReader _reader;
    private boolean _errorDump = false;
    private Logger log;
    static /* synthetic */ Class class$org$apache$fop$fo$ElementMapping;

    public Driver() {
        this.setupDefaultMappings();
    }

    public Driver(InputSource source, OutputStream stream) {
        this();
        this._source = source;
        this._stream = stream;
    }

    public void addElementMapping(String mappingClassName) throws IllegalArgumentException {
        try {
            ElementMapping mapping = (ElementMapping)Class.forName(mappingClassName).newInstance();
            this.addElementMapping(mapping);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + mappingClassName);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + mappingClassName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + mappingClassName);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(String.valueOf(mappingClassName) + " is not an ElementMapping");
        }
    }

    public void addElementMapping(ElementMapping mapping) {
        mapping.addToBuilder(this._treeBuilder);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void dumpError(Exception e) {
        if (this._errorDump) {
            Logger log = this.getLogger();
            if (e instanceof SAXException) {
                log.error("", (Throwable)e);
                if (((SAXException)e).getException() != null) {
                    log.error("", (Throwable)((SAXException)e).getException());
                }
            } else if (e instanceof FOPException) {
                e.printStackTrace();
                if (((FOPException)e).getException() != null) {
                    log.error("", ((FOPException)e).getException());
                }
            } else {
                log.error("", (Throwable)e);
            }
        }
    }

    public ContentHandler getContentHandler() {
        if (!(this._renderer instanceof AWTRenderer) && !(this._renderer instanceof PrintRenderer) && this._stream == null) {
            throw new NullPointerException("OutputStream has not been set. Set before getting the ContentHandler");
        }
        if (this._renderer == null) {
            throw new NullPointerException("The renderer has not been set. Set before getting the ContentHandler");
        }
        StreamRenderer streamRenderer = new StreamRenderer(this._stream, this._renderer);
        streamRenderer.setLogger(this.getLogger());
        this._treeBuilder.setLogger(this.getLogger());
        this._treeBuilder.setStreamRenderer(streamRenderer);
        return this._treeBuilder;
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = new ConsoleLogger(1);
            this.log.error("Logger not set");
        }
        return this.log;
    }

    public static final String getParserClassName() {
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader().getClass().getName();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public Renderer getRenderer() {
        return this._renderer;
    }

    public FormattingResults getResults() {
        try {
            return this._treeBuilder.getStreamRenderer().getResults();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean hasData() {
        return this._treeBuilder.hasData();
    }

    public synchronized void render(Document document) throws FOPException {
        DocumentInputSource source = new DocumentInputSource(document);
        DocumentReader reader = new DocumentReader();
        this.render(reader, source);
    }

    public synchronized void render(XMLReader parser, InputSource source) throws FOPException {
        parser.setContentHandler(this.getContentHandler());
        try {
            parser.parse(source);
        }
        catch (SAXException e) {
            if (e.getException() instanceof FOPException) {
                throw (FOPException)e.getException();
            }
            throw new FOPException(e);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public synchronized void reset() {
        this._source = null;
        this._stream = null;
        this._reader = null;
        this._treeBuilder.reset();
    }

    public synchronized void run() throws IOException, FOPException {
        if (this._renderer == null) {
            this.setRenderer(1);
        }
        if (this._source == null) {
            throw new FOPException("InputSource is not set.");
        }
        if (this._reader == null && !(this._source instanceof DocumentInputSource)) {
            this._reader = ConfigurationReader.createParser();
        }
        if (this._source instanceof DocumentInputSource) {
            this.render(((DocumentInputSource)this._source).getDocument());
        } else {
            this.render(this._reader, this._source);
        }
    }

    public void setErrorDump(boolean dump) {
        this._errorDump = dump;
    }

    public void setInputSource(InputSource source) {
        this._source = source;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setOutputStream(OutputStream stream) {
        this._stream = stream;
    }

    public void setRenderer(int renderer) throws IllegalArgumentException {
        switch (renderer) {
            case 1: {
                this.setRenderer(new PDFRenderer());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Use renderer form of setRenderer() for AWT");
            }
            case 5: {
                throw new IllegalArgumentException("Use renderer form of setRenderer() for PRINT");
            }
            case 6: {
                this.setRenderer(new PCLRenderer());
                break;
            }
            case 7: {
                this.setRenderer(new PSRenderer());
                break;
            }
            case 8: {
                this.setRenderer(new TXTRenderer());
                break;
            }
            case 3: {
                this.setRenderer(new MIFRenderer());
                break;
            }
            case 4: {
                this.setRenderer(new XMLRenderer());
                break;
            }
            case 9: {
                this.setRenderer(new SVGRenderer());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown renderer type");
            }
        }
    }

    public void setRenderer(String rendererClassName) throws IllegalArgumentException {
        try {
            this._renderer = (Renderer)Class.forName(rendererClassName).newInstance();
            this._renderer.setProducer(Version.getVersion());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + rendererClassName);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + rendererClassName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + rendererClassName);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(String.valueOf(rendererClassName) + " is not a renderer");
        }
    }

    public void setRenderer(String rendererClassName, String version) {
        this.setRenderer(rendererClassName);
    }

    public void setRenderer(Renderer renderer) {
        renderer.setLogger(this.getLogger());
        this._renderer = renderer;
    }

    public void setXMLReader(XMLReader reader) {
        this._reader = reader;
    }

    public void setupDefaultMappings() {
        this.addElementMapping("org.apache.fop.fo.StandardElementMapping");
        this.addElementMapping("org.apache.fop.svg.SVGElementMapping");
        this.addElementMapping("org.apache.fop.extensions.ExtensionElementMapping");
        Enumeration providers = Service.providers(class$org$apache$fop$fo$ElementMapping != null ? class$org$apache$fop$fo$ElementMapping : (class$org$apache$fop$fo$ElementMapping = Driver.class$("org.apache.fop.fo.ElementMapping")));
        if (providers != null) {
            while (providers.hasMoreElements()) {
                String str = (String)providers.nextElement();
                try {
                    this.addElementMapping(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }
}

