/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class HalfOuterJoinNode
extends JoinNode {
    private boolean rightOuterJoin;
    private boolean transformed = false;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        super.init(object, object2, object3, object4, null, object6, null);
        this.rightOuterJoin = (Boolean)object5;
        this.flattenableJoin = false;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        if (fromTable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) {
            return fromTable.pushOptPredicate(optimizablePredicate);
        }
        return false;
    }

    public String toString() {
        return "";
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        if (this.rightOuterJoin) {
            ResultSetNode resultSetNode = this.leftResultSet;
            this.leftResultSet = this.rightResultSet;
            this.rightResultSet = resultSetNode;
            this.transformed = true;
        }
        ResultSetNode resultSetNode = super.preprocess(n, groupByList, fromList);
        return resultSetNode;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        FromTable fromTable2 = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(predicateList);
        for (int i = this.joinPredicates.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(i);
            if (!predicate.getPushable()) continue;
            this.getRightPredicateList().addPredicate(predicate);
            this.joinPredicates.removeElementAt(i);
        }
        PredicateList predicateList2 = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        fromTable.pushExpressions(this.getLeftPredicateList());
        fromTable2.pushExpressions(predicateList2);
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        boolean bl;
        ValueNode valueNode;
        ValueNode valueNode2;
        BinaryRelationalOperatorNode binaryRelationalOperatorNode;
        ValueNode valueNode3;
        AndNode andNode;
        ResultSetNode resultSetNode;
        ResultSetNode resultSetNode2;
        boolean bl2 = false;
        if (this.rightOuterJoin) {
            resultSetNode2 = this.rightResultSet;
            resultSetNode = this.leftResultSet;
        } else {
            resultSetNode2 = this.leftResultSet;
            resultSetNode = this.rightResultSet;
        }
        super.normExpressions();
        if (resultSetNode2 instanceof FromBaseTable && resultSetNode instanceof FromBaseTable) {
            return bl2;
        }
        if (resultSetNode2 instanceof HalfOuterJoinNode) {
            bl2 = ((HalfOuterJoinNode)resultSetNode2).LOJ_reorderable(n) || bl2;
        } else if (!(resultSetNode2 instanceof FromBaseTable)) {
            return bl2;
        }
        if (resultSetNode instanceof HalfOuterJoinNode) {
            bl2 = ((HalfOuterJoinNode)resultSetNode).LOJ_reorderable(n) || bl2;
        } else if (!(resultSetNode instanceof FromBaseTable)) {
            return bl2;
        }
        if (this.rightOuterJoin || resultSetNode instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)resultSetNode).rightOuterJoin) {
            return this.LOJ_bindResultColumns(bl2);
        }
        JBitSet jBitSet = resultSetNode2.LOJgetReferencedTables(n);
        JBitSet jBitSet2 = resultSetNode.LOJgetReferencedTables(n);
        if ((jBitSet == null || jBitSet2 == null) && bl2) {
            return this.LOJ_bindResultColumns(bl2);
        }
        ValueNode valueNode4 = this.joinClause;
        while (valueNode4 instanceof AndNode) {
            andNode = (AndNode)valueNode4;
            valueNode3 = andNode.getLeftOperand();
            if (valueNode3 instanceof RelationalOperator && valueNode3.isBinaryEqualsOperatorNode()) {
                binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)valueNode3;
                valueNode2 = binaryRelationalOperatorNode.getLeftOperand();
                valueNode = binaryRelationalOperatorNode.getRightOperand();
                if (!(valueNode2 instanceof ColumnReference) || !(valueNode instanceof ColumnReference)) {
                    return this.LOJ_bindResultColumns(bl2);
                }
                bl = false;
                boolean bl3 = false;
                if (jBitSet.get(((ColumnReference)valueNode2).getTableNumber())) {
                    bl = true;
                    bl3 = true;
                } else if (jBitSet2.get(((ColumnReference)valueNode2).getTableNumber())) {
                    bl = true;
                }
                if (!bl) {
                    return this.LOJ_bindResultColumns(bl2);
                }
                bl = false;
                if (!bl3 && jBitSet.get(((ColumnReference)valueNode).getTableNumber())) {
                    bl = true;
                } else if (bl3 && jBitSet2.get(((ColumnReference)valueNode).getTableNumber())) {
                    bl = true;
                }
                if (!bl) {
                    return this.LOJ_bindResultColumns(bl2);
                }
            } else {
                return this.LOJ_bindResultColumns(bl2);
            }
            valueNode4 = andNode.getRightOperand();
        }
        bl = false;
        if (resultSetNode instanceof HalfOuterJoinNode) {
            JBitSet jBitSet3 = ((HalfOuterJoinNode)resultSetNode).LOJgetNPReferencedTables(n);
            valueNode4 = this.joinClause;
            bl = true;
            while (valueNode4 instanceof AndNode) {
                andNode = (AndNode)valueNode4;
                valueNode3 = andNode.getLeftOperand();
                binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)valueNode3;
                valueNode2 = binaryRelationalOperatorNode.getLeftOperand();
                valueNode = binaryRelationalOperatorNode.getRightOperand();
                if (jBitSet3.get(((ColumnReference)valueNode2).getTableNumber()) || jBitSet3.get(((ColumnReference)valueNode).getTableNumber())) {
                    bl = false;
                    break;
                }
                valueNode4 = andNode.getRightOperand();
            }
        }
        if (bl) {
            if (this.subqueryList.size() != 0 || ((JoinNode)resultSetNode).subqueryList.size() != 0 || this.joinPredicates.size() != 0 || ((JoinNode)resultSetNode).joinPredicates.size() != 0 || this.usingClause != null || ((JoinNode)resultSetNode).usingClause != null) {
                return this.LOJ_bindResultColumns(bl2);
            }
            bl2 = true;
            ResultSetNode resultSetNode3 = resultSetNode2;
            ResultSetNode resultSetNode4 = ((HalfOuterJoinNode)resultSetNode).leftResultSet;
            ResultSetNode resultSetNode5 = ((HalfOuterJoinNode)resultSetNode).rightResultSet;
            ((HalfOuterJoinNode)resultSetNode).rightResultSet = resultSetNode4;
            ((HalfOuterJoinNode)resultSetNode).leftResultSet = resultSetNode3;
            valueNode4 = this.joinClause;
            this.joinClause = ((HalfOuterJoinNode)resultSetNode).joinClause;
            ((HalfOuterJoinNode)resultSetNode).joinClause = valueNode4;
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.leftResultSet = resultSetNode;
            this.rightResultSet = resultSetNode5;
            ((HalfOuterJoinNode)this.leftResultSet).resultColumns = null;
            ((JoinNode)this.leftResultSet).bindResultColumns(fromList);
            boolean bl4 = ((HalfOuterJoinNode)this.leftResultSet).LOJ_reorderable(n);
            return this.LOJ_bindResultColumns(bl2);
        }
        return this.LOJ_bindResultColumns(bl2);
    }

    public boolean LOJ_bindResultColumns(boolean bl) throws StandardException {
        if (bl) {
            this.resultColumns = null;
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindResultColumns(fromList);
        }
        return bl;
    }

    public FromTable transformOuterJoins(ValueNode valueNode, int n) throws StandardException {
        if (valueNode == null) {
            this.leftResultSet.notFlattenableJoin();
            this.rightResultSet.notFlattenableJoin();
            return this;
        }
        super.transformOuterJoins(valueNode, n);
        JBitSet jBitSet = new JBitSet(n);
        ResultSetNode resultSetNode = this.rightOuterJoin ? this.leftResultSet : this.rightResultSet;
        resultSetNode.fillInReferencedTableMap(jBitSet);
        ValueNode valueNode2 = valueNode;
        while (valueNode2 instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode2;
            ValueNode valueNode3 = andNode.getLeftOperand();
            if (valueNode3.isInstanceOf(25)) {
                valueNode2 = andNode.getRightOperand();
                continue;
            }
            if (valueNode3 instanceof RelationalOperator) {
                JBitSet jBitSet2 = new JBitSet(n);
                if (!valueNode3.categorize(jBitSet2, true)) {
                    valueNode2 = andNode.getRightOperand();
                    continue;
                }
                for (int i = 0; i < n; ++i) {
                    if (!jBitSet2.get(i) || !jBitSet.get(i)) continue;
                    JoinNode joinNode = (JoinNode)this.getNodeFactory().getNode(139, this.leftResultSet, this.rightResultSet, this.joinClause, null, this.resultColumns, null, null, this.getContextManager());
                    joinNode.setTableNumber(this.tableNumber);
                    joinNode.setSubqueryList(this.subqueryList);
                    joinNode.setAggregateVector(this.aggregateVector);
                    return joinNode;
                }
            }
            valueNode2 = andNode.getRightOperand();
        }
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
        CostEstimate costEstimate2 = this.getLeftResultSet().getCostEstimate();
        if (costEstimate.rowCount() < costEstimate2.rowCount()) {
            costEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.rowCount());
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        super.generateCore(activationClassBuilder, methodBuilder, 3);
    }

    protected int addOuterJoinArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.rightResultSet.getResultColumns().generateNulls(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.rightOuterJoin);
        return 2;
    }

    protected int getNumJoinArguments() {
        return super.getNumJoinArguments() + 2;
    }

    protected void oneRowRightSide(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) {
        methodBuilder.push(false);
        methodBuilder.push(false);
    }

    ResultSetNode getLogicalLeftResultSet() {
        if (this.rightOuterJoin) {
            return this.rightResultSet;
        }
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        if (this.rightOuterJoin) {
            return this.leftResultSet;
        }
        return this.rightResultSet;
    }

    public boolean isRightOuterJoin() {
        return this.rightOuterJoin;
    }

    public JBitSet LOJgetNPReferencedTables(int n) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.leftResultSet.LOJgetReferencedTables(n);
        }
        return this.rightResultSet.LOJgetReferencedTables(n);
    }
}

