/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;

public class RowUtil {
    public static final DataValueDescriptor[] EMPTY_ROW = new DataValueDescriptor[0];
    public static final FormatableBitSet EMPTY_ROW_BITSET = new FormatableBitSet(0);
    public static final FetchDescriptor EMPTY_ROW_FETCH_DESCRIPTOR = new FetchDescriptor(0);
    private static final FetchDescriptor[] ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS = new FetchDescriptor[]{EMPTY_ROW_FETCH_DESCRIPTOR, new FetchDescriptor(1, 1), new FetchDescriptor(2, 2), new FetchDescriptor(3, 3), new FetchDescriptor(4, 4), new FetchDescriptor(5, 5), new FetchDescriptor(6, 6), new FetchDescriptor(7, 7)};

    private RowUtil() {
    }

    public static DataValueDescriptor getColumn(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            return n < dataValueDescriptorArray.length ? dataValueDescriptorArray[n] : null;
        }
        if (formatableBitSet.getLength() <= n || !formatableBitSet.isSet(n)) {
            return null;
        }
        return n < dataValueDescriptorArray.length ? dataValueDescriptorArray[n] : null;
    }

    public static Object getColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            return n < objectArray.length ? objectArray[n] : null;
        }
        if (formatableBitSet.getLength() <= n || !formatableBitSet.isSet(n)) {
            return null;
        }
        return n < objectArray.length ? objectArray[n] : null;
    }

    public static FormatableBitSet getQualifierBitSet(Qualifier[][] qualifierArray) {
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        if (qualifierArray != null) {
            for (int i = 0; i < qualifierArray.length; ++i) {
                for (int j = 0; j < qualifierArray[i].length; ++j) {
                    int n = qualifierArray[i][j].getColumnId();
                    formatableBitSet.grow(n + 1);
                    formatableBitSet.set(n);
                }
            }
        }
        return formatableBitSet;
    }

    public static int getNumberOfColumns(int n, FormatableBitSet formatableBitSet) {
        int n2 = formatableBitSet.getLength();
        if (n > 0 && n < n2) {
            n2 = n;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!formatableBitSet.isSet(i)) continue;
            ++n3;
        }
        return n3;
    }

    public static boolean isRowEmpty(DataValueDescriptor[] dataValueDescriptorArray) {
        if (dataValueDescriptorArray == null) {
            return true;
        }
        return dataValueDescriptorArray.length == 0;
    }

    public static int columnOutOfRange(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            if (dataValueDescriptorArray.length > n) {
                return n;
            }
            return -1;
        }
        int n2 = formatableBitSet.getLength();
        for (int i = n; i < n2; ++i) {
            if (!formatableBitSet.isSet(i)) continue;
            return i;
        }
        return -1;
    }

    public static int nextColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.getLength();
            while (n < n2) {
                if (formatableBitSet.isSet(n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (objectArray == null) {
            return -1;
        }
        return n < objectArray.length ? n : -1;
    }

    public static final FetchDescriptor getFetchDescriptorConstant(int n) {
        if (n < ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS.length) {
            return ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS[n];
        }
        return new FetchDescriptor(n, n);
    }

    public static DataValueDescriptor[] newTemplate(DataValueFactory dataValueFactory, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2) throws StandardException {
        int n = nArray.length;
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        int n2 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        for (int i = 0; i < n; ++i) {
            if (formatableBitSet != null && (n2 <= i || !formatableBitSet.isSet(i))) continue;
            dataValueDescriptorArray[i] = dataValueFactory.getNull(nArray[i], nArray2[i]);
        }
        return dataValueDescriptorArray;
    }

    private static void newRowFromClassInfoTemplateError() {
    }

    public static DataValueDescriptor[] newRowFromTemplate(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        int n = dataValueDescriptorArray.length;
        while (n-- > 0) {
            if (dataValueDescriptorArray[n] == null) continue;
            dataValueDescriptorArray2[n] = dataValueDescriptorArray[n].getNewNull();
        }
        return dataValueDescriptorArray2;
    }

    public static String toString(Object[] objectArray) {
        return null;
    }

    public static String toString(Hashtable hashtable) {
        return null;
    }

    public static final boolean qualifyRow(Object[] objectArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object;
        int n;
        boolean bl = true;
        for (n = 0; n < qualifierArray[0].length; ++n) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n];
            object = (DataValueDescriptor)objectArray[qualifier.getColumnId()];
            bl = object.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        for (n = 1; n < qualifierArray.length; ++n) {
            bl = false;
            for (int i = 0; i < qualifierArray[n].length; ++i) {
                object = qualifierArray[n][i];
                int n2 = object.getColumnId();
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray[object.getColumnId()];
                bl = dataValueDescriptor.compare(object.getOperator(), object.getOrderable(), object.getOrderedNulls(), object.getUnknownRV());
                if (object.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
            }
            if (!bl) break;
        }
        return bl;
    }
}

