/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;

public class DatabaseScript {
    public static Result getScript(Database database, boolean bl) {
        String string;
        String string2;
        Result result = Result.newSingleColumnResult("COMMAND", 12);
        result.metaData.tableNames[0] = "SYSTEM_SCRIPT";
        if (database.collation.name != null) {
            string2 = StringConverter.toQuotedString(database.collation.name, '\"', true);
            DatabaseScript.addRow(result, "SET DATABASE COLLATION " + string2);
        }
        Iterator iterator = database.getGranteeManager().getRoleNames().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if ("DBA".equals(string2)) continue;
            DatabaseScript.addRow(result, "CREATE ROLE " + string2);
        }
        HashMap hashMap = database.getAliasMap();
        HashMap hashMap2 = Library.getAliasMap();
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = (String)hashMap.get(string3);
            string = (String)hashMap2.get(string3);
            if (string != null && string.equals(string4)) continue;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("CREATE").append(' ').append("ALIAS").append(' ');
            stringBuffer.append(string3);
            stringBuffer.append(" FOR \"");
            stringBuffer.append(string4);
            stringBuffer.append('\"');
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        DatabaseScript.addSchemaStatements(database, result, bl);
        DatabaseScript.addRightsStatements(database, result);
        if (database.logger.hasLog()) {
            boolean bl2;
            int n = database.logger.getWriteDelay();
            boolean bl3 = bl2 = n < 1000;
            if (bl2) {
                if (n != 0 && n < 20) {
                    n = 20;
                }
            } else {
                n /= 1000;
            }
            string = "SET WRITE_DELAY " + n + (bl2 ? " MILLIS" : "");
            DatabaseScript.addRow(result, string);
        }
        return result;
    }

    static void addSchemaStatements(Database database, Result result, boolean bl) {
        Iterator iterator = database.schemaManager.userSchemaNameIterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            int n;
            Object object4;
            HsqlNameManager.HsqlName hsqlName = database.schemaManager.toSchemaHsqlName((String)iterator.next());
            HashMappedList hashMappedList = database.schemaManager.getTables(hsqlName.name);
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("CREATE").append(' ');
            stringBuffer.append("SCHEMA").append(' ');
            stringBuffer.append(hsqlName.statementName).append(' ');
            stringBuffer.append("AUTHORIZATION").append(' ');
            stringBuffer.append("DBA");
            DatabaseScript.addRow(result, stringBuffer.toString());
            Iterator iterator2 = database.schemaManager.sequenceIterator(hsqlName.name);
            while (iterator2.hasNext()) {
                object4 = (NumberSequence)iterator2.next();
                StringBuffer stringBuffer2 = new StringBuffer(128);
                stringBuffer2.append("CREATE").append(' ');
                stringBuffer2.append("SEQUENCE").append(' ');
                stringBuffer2.append(((NumberSequence)object4).getName().statementName).append(' ');
                stringBuffer2.append("AS").append(' ');
                stringBuffer2.append(Types.getTypeString(((NumberSequence)object4).getType())).append(' ');
                stringBuffer2.append("START").append(' ');
                stringBuffer2.append("WITH").append(' ');
                stringBuffer2.append(((NumberSequence)object4).peek()).append(' ');
                if (((NumberSequence)object4).getIncrement() != 1L) {
                    stringBuffer2.append("INCREMENT").append(' ');
                    stringBuffer2.append("BY").append(' ');
                    stringBuffer2.append(((NumberSequence)object4).getIncrement()).append(' ');
                }
                DatabaseScript.addRow(result, stringBuffer2.toString());
            }
            int n2 = hashMappedList.size();
            for (n = 0; n < n2; ++n) {
                String string;
                int n3;
                object3 = (Table)hashMappedList.get(n);
                if (((Table)object3).isView()) continue;
                object2 = new StringBuffer(128);
                DatabaseScript.getTableDDL(database, (Table)object3, n, hsqlArrayList, false, (StringBuffer)object2);
                DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
                for (int i = 1; i < ((Table)object3).getIndexCount(); ++i) {
                    object = ((Table)object3).getIndex(i);
                    if (HsqlNameManager.HsqlName.isReservedIndexName(((Index)object).getName().name)) continue;
                    object2 = new StringBuffer(64);
                    ((StringBuffer)object2).append("CREATE").append(' ');
                    if (((Index)object).isUnique()) {
                        ((StringBuffer)object2).append("UNIQUE").append(' ');
                    }
                    ((StringBuffer)object2).append("INDEX").append(' ');
                    ((StringBuffer)object2).append(((Index)object).getName().statementName);
                    ((StringBuffer)object2).append(' ').append("ON").append(' ');
                    ((StringBuffer)object2).append(((Table)object3).getName().statementName);
                    int[] nArray = ((Index)object).getColumns();
                    n3 = ((Index)object).getVisibleColumns();
                    DatabaseScript.getColumnList((Table)object3, nArray, n3, (StringBuffer)object2);
                    DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
                }
                if (((Table)object3).isText() && ((Table)object3).isDataReadOnly()) {
                    object2 = new StringBuffer(64);
                    ((StringBuffer)object2).append("SET").append(' ').append("TABLE").append(' ');
                    ((StringBuffer)object2).append(((Table)object3).getName().statementName);
                    ((StringBuffer)object2).append(' ').append("READONLY").append(' ').append("TRUE");
                    DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
                }
                if ((string = DatabaseScript.getDataSource((Table)object3)) != null) {
                    DatabaseScript.addRow(result, string);
                }
                object = DatabaseScript.getDataSourceHeader((Table)object3);
                if (!bl && object != null) {
                    DatabaseScript.addRow(result, (String)object);
                }
                int n4 = 12;
                for (n3 = 0; n3 < n4; ++n3) {
                    HsqlArrayList hsqlArrayList2 = ((Table)object3).triggerLists[n3];
                    if (hsqlArrayList2 == null) continue;
                    int n5 = hsqlArrayList2.size();
                    for (int i = 0; i < n5; ++i) {
                        object2 = ((TriggerDef)hsqlArrayList2.get(i)).getDDL();
                        DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
                    }
                }
            }
            n2 = hsqlArrayList.size();
            for (n = 0; n < n2; ++n) {
                object3 = (Constraint)hsqlArrayList.get(n);
                object2 = new StringBuffer(128);
                ((StringBuffer)object2).append("ALTER").append(' ').append("TABLE").append(' ');
                ((StringBuffer)object2).append(((Constraint)object3).getRef().getName().statementName);
                ((StringBuffer)object2).append(' ').append("ADD").append(' ');
                DatabaseScript.getFKStatement((Constraint)object3, (StringBuffer)object2);
                DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
            }
            object4 = database.sessionManager.getSysSession();
            int n6 = hashMappedList.size();
            for (n2 = 0; n2 < n6; ++n2) {
                object2 = (Table)hashMappedList.get(n2);
                if (!bl || !((Table)object2).isIndexCached() || ((Table)object2).isEmpty((Session)object4)) continue;
                DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)hashMappedList.get(n2)));
            }
            n6 = hashMappedList.size();
            for (n2 = 0; n2 < n6; ++n2) {
                object2 = (Table)hashMappedList.get(n2);
                int n7 = ((Table)object2).getIdentityColumn();
                if (((Table)object2).isIndexCached() || n7 == -1) continue;
                object = ((Table)object2).getName().statementName;
                String string = ((Table)object2).getColumn((int)n7).columnName.statementName;
                long l = ((Table)object2).identitySequence.peek();
                StringBuffer stringBuffer3 = new StringBuffer(128);
                stringBuffer3.append("ALTER").append(' ').append("TABLE").append(' ').append((String)object).append(' ').append("ALTER").append(' ').append("COLUMN").append(' ').append(string).append(' ').append("RESTART").append(' ').append("WITH").append(' ').append(l);
                DatabaseScript.addRow(result, stringBuffer3.toString());
            }
            n6 = hashMappedList.size();
            for (n2 = 0; n2 < n6; ++n2) {
                object2 = (Table)hashMappedList.get(n2);
                if (!((Table)object2).isView()) continue;
                View view = (View)hashMappedList.get(n2);
                object = new StringBuffer(128);
                ((StringBuffer)object).append("CREATE").append(' ').append("VIEW").append(' ');
                ((StringBuffer)object).append(view.getName().statementName).append(' ').append('(');
                int n8 = view.getColumnCount();
                for (int i = 0; i < n8; ++i) {
                    ((StringBuffer)object).append(view.getColumn((int)i).columnName.statementName);
                    if (i >= n8 - 1) continue;
                    ((StringBuffer)object).append(',');
                }
                ((StringBuffer)object).append(')').append(' ').append("AS").append(' ');
                ((StringBuffer)object).append(view.getStatement());
                DatabaseScript.addRow(result, ((StringBuffer)object).toString());
            }
        }
    }

    static String getIndexRootsDDL(Table table) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("INDEX").append('\'');
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, HsqlArrayList hsqlArrayList, boolean bl, StringBuffer stringBuffer) {
        Object object;
        Object object2;
        stringBuffer.append("CREATE").append(' ');
        if (table.isTemp) {
            stringBuffer.append("GLOBAL").append(' ');
            stringBuffer.append("TEMPORARY").append(' ');
        }
        if (table.isText()) {
            stringBuffer.append("TEXT").append(' ');
        } else if (table.isCached()) {
            stringBuffer.append("CACHED").append(' ');
        } else {
            stringBuffer.append("MEMORY").append(' ');
        }
        stringBuffer.append("TABLE").append(' ');
        if (bl) {
            stringBuffer.append(table.getName().schema.statementName).append('.');
        }
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        for (int i = 0; i < n2; ++i) {
            Column column = table.getColumn(i);
            String string = column.columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            object2 = Types.getTypeString(column.getType());
            stringBuffer.append((String)object2);
            boolean bl2 = false;
            if (column.getType() == 93) {
                if (column.getSize() != 6) {
                    bl2 = true;
                }
            } else {
                boolean bl3 = bl2 = column.getSize() > 0;
            }
            if (bl2) {
                stringBuffer.append('(');
                stringBuffer.append(column.getSize());
                if (column.getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(column.getScale());
                }
                stringBuffer.append(')');
            }
            if ((object = column.getDefaultDDL()) != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append((String)object);
            }
            if (i == table.getIdentityColumn()) {
                stringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                stringBuffer.append(column.identityStart);
                if (column.identityIncrement != 1L) {
                    stringBuffer.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
                    stringBuffer.append(column.identityIncrement);
                }
                stringBuffer.append(")");
            }
            if (!column.isNullable()) {
                stringBuffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length == 1 && i == nArray[0] && index.getName().isReservedIndexName()) {
                stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        if (nArray.length > 1 || nArray.length == 1 && !index.getName().isReservedIndexName()) {
            stringBuffer.append(',');
            if (!index.getName().isReservedIndexName()) {
                stringBuffer.append("CONSTRAINT").append(' ');
                stringBuffer.append(index.getName().statementName).append(' ');
            }
            stringBuffer.append("PRIMARY").append(' ').append("KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        Constraint[] constraintArray = table.getConstraints();
        int n3 = constraintArray.length;
        block8: for (int i = 0; i < n3; ++i) {
            object2 = constraintArray[i];
            switch (((Constraint)object2).getType()) {
                case 2: {
                    stringBuffer.append(',').append("CONSTRAINT").append(' ');
                    stringBuffer.append(((Constraint)object2).getName().statementName);
                    stringBuffer.append(' ').append("UNIQUE");
                    int[] nArray2 = ((Constraint)object2).getMainColumns();
                    DatabaseScript.getColumnList(((Constraint)object2).getMain(), nArray2, nArray2.length, stringBuffer);
                    continue block8;
                }
                case 0: {
                    object = ((Constraint)object2).getMain();
                    int n4 = database.schemaManager.getTableIndex((Table)object);
                    if (n4 > n) {
                        hsqlArrayList.add(object2);
                        continue block8;
                    }
                    stringBuffer.append(',');
                    DatabaseScript.getFKStatement((Constraint)object2, stringBuffer);
                    continue block8;
                }
                case 3: {
                    try {
                        stringBuffer.append(',').append("CONSTRAINT").append(' ');
                        stringBuffer.append(((Constraint)object2).getName().statementName);
                        stringBuffer.append(' ').append("CHECK").append('(');
                        stringBuffer.append(((Constraint)object2).core.check.getDDL());
                        stringBuffer.append(')');
                        continue block8;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        stringBuffer.append(')');
        if (table.onCommitPreserve) {
            stringBuffer.append(' ').append("ON").append(' ');
            stringBuffer.append("COMMIT").append(' ').append("PRESERVE");
            stringBuffer.append(' ').append("ROWS");
        }
    }

    static String getDataSource(Table table) {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ').append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(' ').append("DESC");
        }
        return stringBuffer.toString();
    }

    static String getDataSourceHeader(Table table) {
        String string = table.getHeader();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ');
        stringBuffer.append("HEADER").append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(table.getColumn((int)nArray[i]).columnName.statementName);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT").append(' ');
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(' ').append("FOREIGN").append(' ').append("KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(' ').append("REFERENCES").append(' ');
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.getDeleteAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getDeleteAction()));
        }
        if (constraint.getUpdateAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getUpdateAction()));
        }
    }

    private static String getFKAction(int n) {
        switch (n) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private static void addRightsStatements(Database database, Result result) {
        String string;
        Object object;
        HashMappedList hashMappedList = database.getUserManager().getUsers();
        Iterator iterator = hashMappedList.values().iterator();
        GranteeManager granteeManager = database.getGranteeManager();
        Iterator iterator2 = granteeManager.getGrantees().iterator();
        while (iterator.hasNext()) {
            object = (User)iterator.next();
            string = ((User)object).getName();
            if (string.equals("PUBLIC")) continue;
            DatabaseScript.addRow(result, ((User)object).getCreateUserDDL());
        }
        while (iterator2.hasNext()) {
            IntValueHashMap intValueHashMap;
            object = (Grantee)iterator2.next();
            string = ((Grantee)object).getName();
            if (string.equals("_SYSTEM") || string.equals("DBA")) continue;
            String string2 = ((Grantee)object).allRolesString();
            if (string2 != null) {
                DatabaseScript.addRow(result, "GRANT " + string2 + " TO " + string);
            }
            if ((intValueHashMap = ((Grantee)object).getRights()) == null) continue;
            Iterator iterator3 = intValueHashMap.keySet().iterator();
            while (iterator3.hasNext()) {
                Object object2 = iterator3.next();
                int n = intValueHashMap.get(object2, 0);
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("GRANT").append(' ');
                stringBuffer.append(GranteeManager.getRightsList(n));
                stringBuffer.append(' ').append("ON").append(' ');
                if (object2 instanceof String) {
                    if (object2.equals("java.lang.Math") || object2.equals("org.hsqldb.Library")) continue;
                    stringBuffer.append("CLASS \"");
                    stringBuffer.append((String)object2);
                    stringBuffer.append('\"');
                } else {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)object2;
                    Table table = database.schemaManager.findUserTable(null, hsqlName.name, hsqlName.schema.name);
                    if (table == null) continue;
                    stringBuffer.append(hsqlName.schema.statementName).append('.').append(hsqlName.statementName);
                }
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(((Grantee)object).getName());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
        }
    }
}

